/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.commands.SelectionParameters;
import fr.exemole.bdfext.scarabe.selection.LigneFicheSelector;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class LigneSelectionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LigneSelection";
    private final ScarabeContext scarabeContext;
    private LigneFicheSelector ligneFicheSelector;

    public LigneSelectionCommand(BdfServer bdfServer, RequestMap requestHandler, ScarabeContext scarabeContext) {
        super(bdfServer, requestHandler);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        Fiches fiches = FichesBuilder.build((String)"id-asc").initSubsetKeyOrder(TreeUtils.getCorpusKeyList((BdfServer)this.bdfServer)).populate((FicheSelector)this.ligneFicheSelector).toFiches();
        this.bdfServer.getSelectionManager().setCustomSelectedFiches(this.bdfUser, fiches);
        SelectionParameters.putSelectionParameters(this.bdfServer, this.bdfUser, "scarabe.selectionparameters_ligne", this.ligneFicheSelector.getSelectionParameters());
    }

    protected void checkParameters() throws ErrorMessageException {
        ScarabeUtils.checkInitState(this.scarabeContext);
        SelectionParameters selectionParameters = new SelectionParameters();
        selectionParameters.initDateIntegerFilter(this.requestHandler, "date");
        selectionParameters.initDateIntegerFilter(this.requestHandler, "dateprevue");
        selectionParameters.initDateIntegerFilter(this.requestHandler, "periode");
        selectionParameters.initDecimalLongFilter(this.requestHandler, "montant");
        selectionParameters.initCondition(this.requestHandler, "beneficiaire", true);
        selectionParameters.initCondition(this.requestHandler, "libelle", true);
        if (selectionParameters.isEmpty()) {
            throw BdfErrors.error((String)"_ error.empty.selectionparameters");
        }
        this.ligneFicheSelector = new LigneFicheSelector(this.bdfServer, this.scarabeContext, this.bdfUser, selectionParameters);
    }
}

