/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.io.IOException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.TermSpaceManager;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.exceptions.NestedLibraryException;
import net.mapeadores.util.script.ScriptFamily;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class LiensXMLPart
extends XMLPart {
    private final TermSpaceManager termSpaceManager;
    private final AtlasFilter atlasFilter;
    private boolean oldCrtxml;
    private final ScriptFamily scriptFamily;

    public LiensXMLPart(XMLWriter xmlWriter, TermSpaceManager termSpaceManager, AtlasFilter atlasFilter, ScriptFamily scriptFamily) {
        super(xmlWriter);
        this.termSpaceManager = termSpaceManager;
        this.atlasFilter = atlasFilter;
        this.scriptFamily = scriptFamily;
    }

    public void setOldCrtxml(boolean oldCrtxml) {
        this.oldCrtxml = oldCrtxml;
    }

    public void addLiens(Liens liens) throws IOException {
        this.openTag("liens");
        this.addLiensStructurels(liens);
        this.addLiensHierarchiques(liens);
        this.addLiensSymetriques(liens);
        if (this.scriptFamily != null && this.scriptFamily.hasScriptFor("add-liens")) {
            ScriptEngineManager factory = new ScriptEngineManager();
            ScriptEngine jsEngine = factory.getEngineByName("javascript");
            jsEngine.put("atlas", liens.getAtlas());
            try {
                this.scriptFamily.evalScriptFor("add-liens", jsEngine);
                Invocable invocableEngine = (Invocable)((Object)jsEngine);
                invocableEngine.invokeFunction("addLiens", new Object[]{this});
            }
            catch (ScriptException se) {
                throw new NestedLibraryException((Exception)se);
            }
            catch (NoSuchMethodException nsme) {
                throw new NestedLibraryException((Exception)nsme);
            }
        }
        this.closeTag("liens");
    }

    private void addLiensStructurels(Liens liens) throws IOException {
        LienStructurelList list = liens.getLienStructurelList();
        int lienCount = list.getLienStructurelCount();
        if (lienCount == 0) {
            return;
        }
        if (this.oldCrtxml) {
            this.openTag("liensstructurels");
        }
        for (int i = 0; i < lienCount; ++i) {
            LienStructurel lst = list.getLienStructurel(i);
            this.openTag("lst");
            this.addCtxt(lst.getContexte1());
            if (!lst.isLienSurLuiMeme()) {
                this.addCtxt(lst.getContexte2());
            }
            DescripteurList descripteurList = lst.getDescripteurList();
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int j = 0; j < descripteurCount; ++j) {
                Descripteur descripteur = descripteurList.getDescripteur(j);
                if (!this.atlasFilter.acceptDescripteur(descripteur)) continue;
                this.addDesc(descripteur);
            }
            this.closeTag("lst");
        }
        if (this.oldCrtxml) {
            this.closeTag("liensstructurels");
        }
    }

    private void addLiensHierarchiques(Liens liens) throws IOException {
        if (this.oldCrtxml) {
            this.openTag("lienshierarchiques");
        }
        LienHierarchiqueGroupList groupList = liens.getLienHierarchiqueGroupList();
        int groupCount = groupList.getLienHierarchiqueGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            LienHierarchiqueGroup lhg = groupList.getLienHierarchiqueGroup(i);
            Descripteur descripteurPere = lhg.getDescripteurPere();
            if (!this.atlasFilter.acceptDescripteur(descripteurPere)) continue;
            this.openTag("lhg");
            this.addDescCtxt(descripteurPere, lhg.getContexte());
            int lienCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lienCount; ++j) {
                Descripteur descripteurFils = lhg.getLienHierarchique(j).getDescripteurFils();
                if (!this.atlasFilter.acceptDescripteur(descripteurFils)) continue;
                this.addDesc(descripteurFils);
            }
            this.closeTag("lhg");
        }
        if (this.oldCrtxml) {
            this.closeTag("lienshierarchiques");
        }
    }

    private void addLiensSymetriques(Liens liens) throws IOException {
        if (this.oldCrtxml) {
            this.openTag("lienssymetriques");
        }
        LienSymetriqueList lsl = liens.getLienSymetriqueList();
        int lienCount = lsl.getLienSymetriqueCount();
        for (int j = 0; j < lienCount; ++j) {
            LienSymetrique lsm = lsl.getLienSymetrique(j);
            this.openTag("lsm");
            for (int i = 0; i < lsm.getDescripteurCount(); ++i) {
                this.addDescCtxt(lsm.getDescripteur(i), lsm.getContexte(i));
            }
            this.closeTag("lsm");
        }
        if (this.oldCrtxml) {
            this.closeTag("lienssymetriques");
        }
    }

    public void addDescCtxt(Descripteur descripteur, Contexte contexte) throws IOException {
        this.openTag("desc-ctxt");
        this.addDesc(descripteur);
        this.addCtxt(contexte);
        this.closeTag("desc-ctxt");
    }

    public void addDesc(Descripteur descripteur) throws IOException {
        this.startOpenTag("desc");
        this.addAttribute("iddesc", this.termSpaceManager.toString(descripteur.getIddesc()));
        this.closeEmptyTag();
    }

    public void addCtxt(Contexte contexte) throws IOException {
        if (StructureUtils.isHorsgrilleContexte(contexte)) {
            return;
        }
        this.startOpenTag("ctxt");
        if (this.oldCrtxml) {
            this.addAttribute("grl", contexte.getGrille().getGrilleName());
        } else {
            this.addAttribute("grille", contexte.getGrille().getGrilleName());
        }
        this.addAttribute("idctxt", contexte.getIdctxt());
        this.closeEmptyTag();
    }
}

