/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;

public class DefaultVentilation
implements Ventilation {
    private VentilationParameters ventilationParameters;
    private Term root;
    private Atlas atlas;
    private List<InternalSecteur> firstLevel;
    private InternalSecteurList firstLevelList;
    private Map<Integer, InternalSecteur> secteurByCodeMap = new HashMap<Integer, InternalSecteur>();
    private Map<String, ColorStyle> colorStyleMap = new HashMap<String, ColorStyle>();
    private int pas = 0;
    private ColorStyle globalColorStyle;
    private int liaisonCount;
    private LiaisonFilter liaisonFilter = null;
    private boolean ignoreEmpty;

    private DefaultVentilation(VentilationParameters ventilationParameters) {
        this.ventilationParameters = ventilationParameters;
        this.root = ventilationParameters.getVentilationRoot();
        this.atlas = ventilationParameters.getAtlas();
        this.liaisonFilter = ventilationParameters.getLiaisonFilter();
        this.firstLevel = new ArrayList<InternalSecteur>();
        this.firstLevelList = new InternalSecteurList(this.firstLevel);
        this.ignoreEmpty = ventilationParameters.getSessionConf().getBoolean("ignore.empty.secteur");
    }

    private void initVentilationComplete(boolean ignoreHorsGrille) {
        Structure structure = this.atlas.getStructure();
        this.globalColorStyle = ColorStyle.COMPLETE_COLORSTYLE;
        GrilleList list = structure.getGrilleList();
        int grilleCount = list.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            Grille grille = list.getGrille(i);
            this.firstLevel.add(new InternalSecteur(grille));
        }
        if (!ignoreHorsGrille) {
            this.firstLevel.add(new InternalSecteur(StructureUtils.getHorsgrilleContexte(structure), null));
        }
    }

    private void initFormGrilleOrContexte(Term start) {
        if (start instanceof Grille) {
            Grille grille = (Grille)start;
            this.globalColorStyle = ColorStyle.fromGrille(grille);
            ContexteList list = grille.getFirstLevelContexteList();
            int contexteCount = list.getContexteCount();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte child = list.getContexte(i);
                this.firstLevel.add(new InternalSecteur(child, null));
            }
        } else {
            Contexte contexte = (Contexte)start;
            if (contexte.isActive()) {
                this.globalColorStyle = ColorStyle.fromActiveContexte(contexte);
                this.firstLevel.add(new InternalSecteur(contexte, null));
            } else {
                this.globalColorStyle = ColorStyle.fromContexte(contexte);
                ContexteList list = contexte.getChildren();
                int contexteCount = list.getContexteCount();
                for (int i = 0; i < contexteCount; ++i) {
                    Contexte child = list.getContexte(i);
                    this.firstLevel.add(new InternalSecteur(child, null));
                }
            }
        }
    }

    private void initByDescripteurInFamille(Contexte famille, boolean recursive) {
        Descripteur descroot = null;
        if (this.root != null && this.root instanceof Descripteur) {
            descroot = (Descripteur)this.root;
        }
        InternalSecteur familleSecteur = new InternalSecteur(famille, null, this.atlas.getDescripteurs(), descroot, recursive);
        for (InternalSecteur defSecteur : familleSecteur.sousSecteurs) {
            defSecteur.parent = null;
            this.firstLevel.add(defSecteur);
        }
        this.globalColorStyle = familleSecteur.colorStyle;
        this.secteurByCodeMap.remove(familleSecteur.code);
    }

    private void initByFamille(Grille grilleDesFamilles, Contexte sansfamilleContexte) {
        this.globalColorStyle = ColorStyle.BYFAMILLE_COLORSTYLE;
        ContexteList list = grilleDesFamilles.getFirstLevelContexteList();
        int contexteCount = list.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            Contexte contexte = list.getContexte(i);
            this.firstLevel.add(new InternalSecteur(contexte, null));
        }
        if (sansfamilleContexte != null) {
            this.firstLevel.add(new InternalSecteur(sansfamilleContexte, null));
        }
    }

    public void endInit() {
        if (this.ignoreEmpty) {
            Iterator<InternalSecteur> it = this.firstLevel.iterator();
            while (it.hasNext()) {
                InternalSecteur defaultSecteur = it.next();
                if (defaultSecteur.testActivity()) continue;
                it.remove();
            }
        }
        int size = this.firstLevel.size();
        for (int i = 0; i < size; ++i) {
            this.firstLevel.get(i).initIndex(i);
        }
    }

    public static DefaultVentilation createVentilationComplete(VentilationParameters ventilationParameters, boolean ignoreHorsGrille) {
        DefaultVentilation ventilation = new DefaultVentilation(ventilationParameters);
        ventilation.initVentilationComplete(ignoreHorsGrille);
        return ventilation;
    }

    public static DefaultVentilation createVentilationByGrilleOrContexte(VentilationParameters ventilationParameters, Term grilleOrContexte) {
        DefaultVentilation ventilation = new DefaultVentilation(ventilationParameters);
        ventilation.initFormGrilleOrContexte(grilleOrContexte);
        return ventilation;
    }

    public static DefaultVentilation createVentilationByDescripteurInFamille(VentilationParameters ventilationParameters, Contexte famille, boolean includeSousFamille) {
        DefaultVentilation ventilation = new DefaultVentilation(ventilationParameters);
        ventilation.initByDescripteurInFamille(famille, includeSousFamille);
        return ventilation;
    }

    public static DefaultVentilation createVentilationByFamille(VentilationParameters ventilationParameters, boolean ignoreSansFamille) {
        Structure structure = ventilationParameters.getAtlas().getStructure();
        Grille grille = structure.getGrilleDesFamilles();
        Contexte contexteSansFamille = null;
        if (!ignoreSansFamille) {
            contexteSansFamille = StructureUtils.getSansfamilleContexte(structure);
        }
        DefaultVentilation ventilation = new DefaultVentilation(ventilationParameters);
        ventilation.initByFamille(grille, contexteSansFamille);
        return ventilation;
    }

    @Override
    public SecteurList getFirstLevelSecteurList() {
        return this.firstLevelList;
    }

    @Override
    public Atlas getSource() {
        return this.atlas;
    }

    public boolean createLiaison(Lien lien, Term termeLiaison, Term termeSecteur) {
        return this.createLiaison(lien, termeLiaison, termeSecteur, -1);
    }

    public boolean createLiaison(Lien lien, Term termeLiaison, Term termeSecteur, int indexInLien) {
        InternalSecteur defSecteur = this.secteurByCodeMap.get(termeSecteur.getCode());
        if (defSecteur == null) {
            return false;
        }
        return defSecteur.addLiaison(lien, termeLiaison, VentilationUtils.getLiaisonPosition(lien, termeLiaison), indexInLien);
    }

    public void createLiaisonsFromLienHierarchiqueGroup(LienHierarchiqueGroup lhg, Term termeSecteur) {
        InternalSecteur defSecteur = this.secteurByCodeMap.get(termeSecteur.getCode());
        if (defSecteur == null) {
            return;
        }
        int lhCount = lhg.getLienHierarchiqueCount();
        for (int i = 0; i < lhCount; ++i) {
            LienHierarchique lh = lhg.getLienHierarchique(i);
            defSecteur.addLiaison(lh, lh.getDescripteurFils(), (short)1, i);
        }
    }

    public void createLiaisonsFromLienStructurel(LienStructurel lienStructurel, Term termeSecteur) {
        InternalSecteur defSecteur = this.secteurByCodeMap.get(termeSecteur.getCode());
        if (defSecteur == null) {
            return;
        }
        DescripteurList descripteurList = lienStructurel.getDescripteurList();
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            Descripteur descripteur = descripteurList.getDescripteur(i);
            defSecteur.addLiaison(lienStructurel, descripteur, (short)1, i);
        }
    }

    @Override
    public Term getRoot() {
        return this.root;
    }

    private int createCode(Object obj) {
        int code = this.pas++;
        return code;
    }

    @Override
    public ColorStyle getColorStyle() {
        return this.globalColorStyle;
    }

    @Override
    public VentilationName getVentilationName() {
        return this.ventilationParameters.getVentilationName();
    }

    private ColorStyle getOrCreateColorStyle(Grille grille) {
        String name = ColorStyle.getStyleName(grille);
        ColorStyle colorStyle = this.colorStyleMap.get(name);
        if (colorStyle == null) {
            colorStyle = ColorStyle.fromGrille(grille);
            this.colorStyleMap.put(name, colorStyle);
        }
        return colorStyle;
    }

    private ColorStyle getOrCreateColorStyle(Contexte contexte) {
        String name = ColorStyle.getStyleName(contexte);
        ColorStyle colorStyle = this.colorStyleMap.get(name);
        if (colorStyle == null) {
            colorStyle = ColorStyle.fromContexte(contexte);
            this.colorStyleMap.put(name, colorStyle);
        }
        return colorStyle;
    }

    private static class InternalSecteurList
    implements SecteurList {
        private final List<InternalSecteur> secteurArray;

        private InternalSecteurList(List<InternalSecteur> secteurArray) {
            this.secteurArray = secteurArray;
        }

        @Override
        public Secteur getSecteur(int index) {
            return this.secteurArray.get(index);
        }

        @Override
        public int getSecteurCount() {
            return this.secteurArray.size();
        }
    }

    private class InternalSecteur
    implements Secteur {
        private Term terme;
        private InternalSecteur parent;
        private List<InternalSecteur> sousSecteurs;
        private SecteurList sousSecteursList;
        private List<Liaison> liaisons;
        private LiaisonList liaisonsWrapper;
        private boolean active;
        private int code;
        private int profondeur = -1;
        private int index;
        private ColorStyle colorStyle;

        private InternalSecteur(Term terme, InternalSecteur parent, boolean active) {
            this.terme = terme;
            this.active = active;
            this.parent = parent;
            DefaultVentilation.this.secteurByCodeMap.put(terme.getCode(), this);
            this.code = DefaultVentilation.this.createCode(this);
        }

        private InternalSecteur(Grille grille) {
            this(grille, null, false);
            this.colorStyle = defaultVentilation.getOrCreateColorStyle(grille);
            this.initGrilleSousSecteur(grille.getFirstLevelContexteList(), this);
        }

        private InternalSecteur(Contexte contexte, InternalSecteur parent) {
            this((Term)contexte, parent, contexte.isActive());
            Grille grille;
            Contexte ctxtparent;
            short type = contexte.getTermType();
            this.colorStyle = type == 4 || type == 6 ? defaultVentilation.getOrCreateColorStyle(contexte) : ((ctxtparent = contexte.getParent()) == null ? ((grille = contexte.getGrille()) != null ? defaultVentilation.getOrCreateColorStyle(grille) : defaultVentilation.getOrCreateColorStyle(contexte)) : defaultVentilation.getOrCreateColorStyle(ctxtparent));
            this.initGrilleSousSecteur(contexte.getChildren(), this);
        }

        private void initGrilleSousSecteur(ContexteList liste, InternalSecteur parent) {
            int contexteCount = liste.getContexteCount();
            if (contexteCount == 0) {
                this.sousSecteursList = VentilationUtils.EMPTY_SECTEUR_LIST;
            } else {
                this.sousSecteurs = new ArrayList<InternalSecteur>();
                for (int i = 0; i < contexteCount; ++i) {
                    this.sousSecteurs.add(new InternalSecteur(liste.getContexte(i), parent));
                }
                this.sousSecteursList = new InternalSecteurList(this.sousSecteurs);
            }
        }

        private InternalSecteur(Descripteur descripteur, InternalSecteur parent, ColorStyle colorStyle) {
            this((Term)descripteur, parent, true);
            this.sousSecteursList = VentilationUtils.EMPTY_SECTEUR_LIST;
            this.colorStyle = colorStyle;
        }

        private InternalSecteur(Contexte famille, InternalSecteur parent, Descripteurs descripteurs, Descripteur descroot, boolean recursive) {
            this((Term)famille, parent, false);
            DescripteurList descripteurList = descripteurs.getInFamilleDescripteurList(famille);
            ContexteList sousfamillesList = null;
            int descripteurCount = descripteurList.getDescripteurCount();
            boolean forcedRecursive = recursive;
            if (!famille.isActive()) {
                forcedRecursive = true;
            }
            if (forcedRecursive) {
                sousfamillesList = famille.getChildren();
            }
            this.sousSecteurs = new ArrayList<InternalSecteur>();
            this.colorStyle = defaultVentilation.getOrCreateColorStyle(famille);
            for (int i = 0; i < descripteurCount; ++i) {
                Descripteur descripteur = descripteurList.getDescripteur(i);
                if (descroot != null && descroot.equals(descripteur)) continue;
                this.sousSecteurs.add(defaultVentilation.new InternalSecteur(descripteur, this, this.colorStyle));
            }
            if (sousfamillesList != null) {
                int sousfamillesCount = sousfamillesList.getContexteCount();
                for (int i = 0; i < sousfamillesCount; ++i) {
                    this.sousSecteurs.add(defaultVentilation.new InternalSecteur(sousfamillesList.getContexte(i), this, descripteurs, descroot, recursive));
                }
            }
            this.sousSecteursList = new InternalSecteurList(this.sousSecteurs);
        }

        private void initIndex(int index) {
            this.index = index;
            if (this.sousSecteurs != null) {
                int size = this.sousSecteurs.size();
                for (int i = 0; i < size; ++i) {
                    this.sousSecteurs.get(i).initIndex(i);
                }
            }
        }

        @Override
        public LiaisonList getLiaisonList() {
            if (this.liaisons == null) {
                return VentilationUtils.EMPTY_LIAISON_LIST;
            }
            return this.liaisonsWrapper;
        }

        @Override
        public SecteurList getChildren() {
            return this.sousSecteursList;
        }

        @Override
        public Term getSecteurTerm() {
            return this.terme;
        }

        private boolean testActivity() {
            if (this.liaisons != null) {
                return true;
            }
            this.active = false;
            if (this.sousSecteurs == null) {
                return false;
            }
            Iterator<InternalSecteur> it = this.sousSecteurs.iterator();
            while (it.hasNext()) {
                InternalSecteur soussecteur = it.next();
                if (soussecteur.testActivity()) continue;
                it.remove();
            }
            return !this.sousSecteurs.isEmpty();
        }

        private boolean addLiaison(Lien lien, Term termeLiaison, short position, int indexInLien) {
            DefaultLiaison defliaison = new DefaultLiaison(lien, termeLiaison, position, indexInLien);
            if (DefaultVentilation.this.liaisonFilter != null && !DefaultVentilation.this.liaisonFilter.accept(defliaison)) {
                return false;
            }
            if (this.liaisons == null) {
                this.liaisons = new ArrayList<Liaison>();
                this.liaisonsWrapper = VentilationUtils.wrapLiaisonList(this.liaisons);
            }
            this.liaisons.add(defliaison);
            DefaultVentilation.this.liaisonCount++;
            return true;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public Ventilation getVentilation() {
            return DefaultVentilation.this;
        }

        @Override
        public int getVentilationCode() {
            return this.code;
        }

        @Override
        public Secteur getParent() {
            return this.parent;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getProfondeur() {
            if (this.profondeur == -1) {
                int p = 0;
                InternalSecteur ancetre = this.parent;
                while (ancetre != null) {
                    ++p;
                    ancetre = ancetre.parent;
                }
                this.profondeur = p;
            }
            return this.profondeur;
        }

        @Override
        public ColorStyle getColorStyle() {
            return this.colorStyle;
        }

        private class DefaultLiaison
        implements Liaison {
            private final Lien lien;
            private final Term term;
            private final int code;
            private final short position;
            private final int indexInLien;

            private DefaultLiaison(Lien lien, Term term, short position, int indexInLien) {
                this.lien = lien;
                this.term = term;
                this.code = DefaultVentilation.this.createCode(this);
                this.position = position;
                this.indexInLien = indexInLien;
            }

            @Override
            public int getIndexInLien() {
                return this.indexInLien;
            }

            @Override
            public Lien getLien() {
                return this.lien;
            }

            @Override
            public Term getTerm() {
                return this.term;
            }

            @Override
            public Secteur getSecteur() {
                return InternalSecteur.this;
            }

            @Override
            public int getVentilationCode() {
                return this.code;
            }

            @Override
            public short getPosition() {
                return this.position;
            }
        }
    }
}

