/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class DetailImputationPage
extends PageHtmlPrinter
implements HtmlProducer {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    private final Corpus corpus;
    private final Motcle motcle;
    private float total = 0.0f;
    private FieldKey montantFieldKey;
    private FieldKey dateFieldKey;
    private final SortedSet<Ligne> sortieList = new TreeSet<Ligne>();
    private final SortedSet<Ligne> entreeList = new TreeSet<Ligne>();
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.FRENCH);

    public DetailImputationPage(Corpus corpus, Motcle motcle) {
        this.corpus = corpus;
        this.motcle = motcle;
        this.init();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
    }

    public void writeHtml(Appendable writer) throws IOException {
        this.initPrinter(writer);
        this.start(DEFAULT_LANG, "D\u00e9tail");
        this.TABLE();
        this.printList(this.sortieList);
        this.printList(this.entreeList);
        this.TR();
        this.TD()._TD();
        this.TD()._TD();
        this.TD()._TD();
        HtmlAttributes spanAttribute = this.total > 0.0f ? HA.style((String)"color: red") : HA.style((String)"color: blue");
        this.TD().SPAN(spanAttribute).__escape((CharSequence)this.numberFormat.format(this.total))._SPAN()._TD();
        this._TR();
        this._TABLE();
        this.end();
    }

    private void printList(Collection<Ligne> col) {
        for (Ligne ligne : col) {
            this.TR();
            this.TD().__escape((CharSequence)ligne.date.toISOString())._TD();
            this.TD().__escape((CharSequence)ligne.ficheMeta.getTitle())._TD();
            this.TD().__escape((CharSequence)this.numberFormat.format(ligne.montant))._TD();
            this._TR();
        }
    }

    private void init() {
        this.montantFieldKey = FieldKey.build((short)1, (String)"montant");
        this.dateFieldKey = FieldKey.build((short)1, (String)"date");
        Fichotheque fichotheque = this.corpus.getFichotheque();
        Junctions junctions = fichotheque.getJunctions((SubsetItem)this.motcle, (Subset)this.corpus);
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.corpus);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            Object obj2 = fichePointeur.getValue(this.dateFieldKey);
            if (obj2 == null || !(obj2 instanceof DateItem)) continue;
            FuzzyDate date = ((DateItem)obj2).getDate();
            Object obj = fichePointeur.getValue(this.montantFieldKey);
            if (obj == null || !(obj instanceof NumberItem)) continue;
            NumberItem numberItem = (NumberItem)obj;
            float f = numberItem.getDecimal().toFloat();
            this.total += f;
            if (f <= 0.0f) {
                this.sortieList.add(new Ligne(ficheMeta, f, date));
                continue;
            }
            this.entreeList.add(new Ligne(ficheMeta, f, date));
        }
    }

    private class Ligne
    implements Comparable<Ligne> {
        private final FicheMeta ficheMeta;
        private final float montant;
        private final FuzzyDate date;

        private Ligne(FicheMeta ficheMeta, float montant, FuzzyDate date) {
            this.ficheMeta = ficheMeta;
            this.montant = montant;
            this.date = date;
        }

        @Override
        public int compareTo(Ligne other) {
            int comp = this.date.compareTo(other.date);
            if (comp != 0) {
                return comp;
            }
            if (this.ficheMeta.getId() < other.ficheMeta.getId()) {
                return -1;
            }
            if (this.ficheMeta.getId() > other.ficheMeta.getId()) {
                return 1;
            }
            return 0;
        }
    }
}

