<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    
    <xsl:template name="utils-replaceInText">
        <xsl:param name="param_Text" />
        <xsl:param name="param_Target" />
        <xsl:param name="param_Replacement" />
        <xsl:choose>
            <xsl:when test="contains($param_Text, $param_Target)">
                <xsl:value-of select="substring-before($param_Text,$param_Target)" />
                <xsl:value-of select="$param_Replacement" />
                <xsl:call-template name="utils-replaceInText">
                    <xsl:with-param name="param_Text"
                    select="substring-after($param_Text,$param_Target)" />
                    <xsl:with-param name="param_Target" select="$param_Target" />
                    <xsl:with-param name="param_Replacement" select="$param_Replacement" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$param_Text" />
            </xsl:otherwise>
        </xsl:choose>
      </xsl:template>
      
</xsl:stylesheet>
