/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.coupleparser;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.coupleparser.Couple;
import net.mapeadores.util.text.coupleparser.ErrorCouple;
import net.mapeadores.util.text.coupleparser.IdalphaCouple;
import net.mapeadores.util.text.coupleparser.IntegerCouple;

public class CoupleParser {
    public static final String ALLOWED_SEPARATOR = "\n\u00a7\u00b6$";
    private char separator = (char)10;
    public static final short INTEGER_MODE = 1;
    public static final short IDALPHA_MODE = 2;
    private final short mode;
    private static final int START_STEP = 0;
    private static final int INTEGER_STEP = 1;
    private static final int IDALPHA_STEP = 11;
    private static final int IDALPHA_SPACEQUESTION_STEP = 12;
    private static final int SEPARATOR_STEP = 2;
    private static final int TRIM_STEP = 3;
    private static final int VALUE_STEP = 4;
    private static final int ERROR_STEP = -1;

    public CoupleParser(short mode) {
        this.mode = mode;
    }

    public void setSeparator(char separator) {
        if (ALLOWED_SEPARATOR.indexOf(separator) == -1) {
            throw new IllegalArgumentException("wrong separator = " + separator);
        }
        this.separator = separator;
    }

    public Couple[] parse(CharSequence charSequence) {
        int length = charSequence.length();
        LineBuffer lineBuffer = null;
        if (this.mode == 1) {
            lineBuffer = new IntegerLineBuffer();
        } else if (this.mode == 2) {
            lineBuffer = new IdalphaLineBuffer();
        }
        for (int i = 0; i < length; ++i) {
            char carac = charSequence.charAt(i);
            if (carac == '\\') {
                if (i < length - 1) {
                    char next = charSequence.charAt(i + 1);
                    if (next == '\r') {
                        lineBuffer.incrementLineNumber();
                        if (this.separator != '\n') {
                            lineBuffer.appendChar('\\');
                        }
                        lineBuffer.appendChar('\r');
                        if (i < length - 2 && charSequence.charAt(i + 2) == '\n') {
                            lineBuffer.appendChar('\n');
                            ++i;
                        }
                    } else if (next == '\n') {
                        lineBuffer.incrementLineNumber();
                        if (this.separator != '\n') {
                            lineBuffer.appendChar('\\');
                        }
                        lineBuffer.appendChar('\n');
                    } else if (next == this.separator) {
                        lineBuffer.appendChar(next);
                    } else {
                        lineBuffer.appendChar('\\');
                        lineBuffer.appendChar(next);
                    }
                    ++i;
                    continue;
                }
                lineBuffer.appendChar('\\');
                continue;
            }
            if (carac == '\r') {
                if (this.separator == '\n') {
                    if (i < length - 1 && charSequence.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    lineBuffer.flushLine();
                } else if (i < length - 1) {
                    lineBuffer.appendChar('\r');
                    if (charSequence.charAt(i + 1) == '\n') {
                        lineBuffer.appendChar('\n');
                        ++i;
                    }
                }
                lineBuffer.incrementLineNumber();
                continue;
            }
            if (carac == '\n') {
                if (this.separator == '\n') {
                    lineBuffer.flushLine();
                } else {
                    lineBuffer.appendChar('\n');
                }
                lineBuffer.incrementLineNumber();
                continue;
            }
            if (carac == this.separator) {
                lineBuffer.flushLine();
                continue;
            }
            lineBuffer.appendChar(carac);
        }
        lineBuffer.flushLine();
        return lineBuffer.toCoupleArray();
    }

    private static boolean isCommonSeparator(char c) {
        switch (c) {
            case ',': 
            case ';': 
            case '=': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    public static char[] getAllowedCoupleSeparateurArray() {
        return ALLOWED_SEPARATOR.toCharArray();
    }

    public static String[] getAllowedCoupleSeparateurArrayToString() {
        return StringUtils.toStringArray(ALLOWED_SEPARATOR);
    }

    private class IntegerLineBuffer
    extends LineBuffer {
        private int integer;

        private IntegerLineBuffer() {
            this.integer = 0;
        }

        @Override
        public void flushLine() {
            if (this.step == 0) {
                return;
            }
            Couple couple = null;
            couple = this.step == -1 ? new ErrorCouple(this.startLineNumber, this.valueBuffer.toString()) : new IntegerCouple(this.integer, this.startLineNumber, this.valueBuffer.toString());
            this.flushLine(couple);
            this.integer = 0;
        }

        @Override
        public void appendChar(char c) {
            switch (this.step) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    this.reinitStartLineNumber();
                    int firstTest = StringUtils.testNumberChar(c);
                    if (firstTest == -1) {
                        this.valueBuffer.append(c);
                        this.step = -1;
                        break;
                    }
                    this.integer = firstTest;
                    this.step = 1;
                    break;
                }
                case 1: {
                    int test = StringUtils.testNumberChar(c);
                    if (test != -1) {
                        this.integer = this.integer * 10 + test;
                        break;
                    }
                    this.testSeparator(c);
                    break;
                }
                case 2: {
                    this.testSeparator(c);
                    break;
                }
                case 3: {
                    this.testTrim(c);
                    break;
                }
                case -1: 
                case 4: {
                    this.appendInValue(c);
                    break;
                }
                default: {
                    throw new SwitchException("step = " + this.step);
                }
            }
        }
    }

    private class IdalphaLineBuffer
    extends LineBuffer {
        private StringBuilder idalphaBuffer;

        private IdalphaLineBuffer() {
            this.idalphaBuffer = new StringBuilder();
        }

        @Override
        public void flushLine() {
            if (this.step == 0) {
                return;
            }
            Couple couple = null;
            couple = this.step == -1 ? new ErrorCouple(this.startLineNumber, this.valueBuffer.toString()) : new IdalphaCouple(this.idalphaBuffer.toString(), this.startLineNumber, this.valueBuffer.toString());
            this.flushLine(couple);
            this.idalphaBuffer = new StringBuilder();
        }

        @Override
        public void appendChar(char c) {
            switch (this.step) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    this.reinitStartLineNumber();
                    boolean valid = Idalpha.isValidNoSpaceChar(c);
                    if (!valid) {
                        this.valueBuffer.append(c);
                        this.step = -1;
                        break;
                    }
                    this.idalphaBuffer.append(c);
                    this.step = 11;
                    break;
                }
                case 11: {
                    if (c == ' ') {
                        this.step = 12;
                        break;
                    }
                    boolean valid2 = Idalpha.isValidNoSpaceChar(c);
                    if (valid2) {
                        this.idalphaBuffer.append(c);
                        break;
                    }
                    this.testSeparator(c);
                    break;
                }
                case 12: {
                    if (Idalpha.isValidNoSpaceChar(c)) {
                        this.idalphaBuffer.append(' ');
                        this.idalphaBuffer.append(c);
                        this.step = 11;
                        break;
                    }
                    this.testSeparator(c);
                    break;
                }
                case 2: {
                    this.testSeparator(c);
                    break;
                }
                case 3: {
                    this.testTrim(c);
                    break;
                }
                case -1: 
                case 4: {
                    this.appendInValue(c);
                    break;
                }
                default: {
                    throw new SwitchException("step = " + this.step);
                }
            }
        }
    }

    private abstract class LineBuffer {
        int lineNumber = 1;
        List<Couple> list = new ArrayList<Couple>();
        StringBuilder valueBuffer = new StringBuilder();
        int step = 0;
        int startLineNumber = 0;

        private LineBuffer() {
        }

        public abstract void flushLine();

        public Couple[] toCoupleArray() {
            int size = this.list.size();
            Couple[] result = new Couple[size];
            for (int i = 0; i < size; ++i) {
                Couple couple;
                result[i] = couple = this.list.get(i);
            }
            return result;
        }

        public abstract void appendChar(char var1);

        public void incrementLineNumber() {
            ++this.lineNumber;
        }

        protected void flushLine(Couple couple) {
            this.list.add(couple);
            this.step = 0;
            this.valueBuffer = new StringBuilder();
        }

        protected void reinitStartLineNumber() {
            this.startLineNumber = this.lineNumber;
        }

        protected void testSeparator(char c) {
            if (Character.isWhitespace(c)) {
                this.step = 2;
            } else if (!CoupleParser.isCommonSeparator(c)) {
                this.valueBuffer.append(c);
                this.step = 4;
            } else {
                this.step = 3;
            }
        }

        protected void appendInValue(char c) {
            this.valueBuffer.append(c);
        }

        protected void testTrim(char c) {
            if (!Character.isWhitespace(c)) {
                this.valueBuffer.append(c);
                this.step = 4;
            }
        }
    }
}

