/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladeArgumentFactory;
import net.mapeadores.util.text.ValueResolver;

public class AccoladePattern {
    public static final ValueResolver DEFAULT_VALUERESOLVER = new NoneValueResolver();
    public static final AccoladeArgumentFactory DEFAULT_ACCOLADEARGUMENTFACTORY = new DefaultAccoladeArgumentFactory();
    private String patternString;
    PatternPart[] patternPartArray;
    int bufferSize = 0;
    int argumentCount = 0;

    private AccoladePattern() {
    }

    public AccoladePattern(String patternString) throws ParseException {
        this(patternString, null);
    }

    public AccoladePattern(String patternString, AccoladeArgumentFactory accoladeArgumentFactory) throws ParseException {
        this.patternString = patternString;
        if (accoladeArgumentFactory == null) {
            accoladeArgumentFactory = DEFAULT_ACCOLADEARGUMENTFACTORY;
        }
        List<PatternPart> list = this.buildPattern(patternString, accoladeArgumentFactory);
        int size = list.size();
        this.patternPartArray = new PatternPart[size];
        for (int i = 0; i < size; ++i) {
            this.patternPartArray[i] = list.get(i);
        }
        this.bufferSize = this.bufferSize < 8 ? 16 : (this.bufferSize += 10 * this.argumentCount);
    }

    public static AccoladePattern getNoArgumentPattern(String prefix, String rawString) {
        String text = prefix + rawString;
        AccoladePattern pattern = new AccoladePattern();
        PatternPart[] pp = new PatternPart[]{new PatternPart(text)};
        pattern.patternPartArray = pp;
        pattern.patternString = rawString;
        pattern.bufferSize = text.length();
        return pattern;
    }

    public static List<Object> parseToList(String text) throws ParseException {
        AccoladePattern accoladePattern = new AccoladePattern(text);
        return accoladePattern.toList();
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public String format(ValueResolver valueResolver) {
        StringBuilder buf = new StringBuilder(this.bufferSize);
        for (int i = 0; i < this.patternPartArray.length; ++i) {
            PatternPart patternPart = this.patternPartArray[i];
            if (patternPart.isArgumentPart()) {
                buf.append(valueResolver.getValue(patternPart.getPatternArgument()));
                continue;
            }
            buf.append(patternPart.getText());
        }
        return buf.toString();
    }

    public List<Object> toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PatternPart patternPart : this.patternPartArray) {
            if (patternPart.isArgumentPart()) {
                list.add(patternPart.patternArgument);
                continue;
            }
            list.add(patternPart.text);
        }
        return list;
    }

    private List<PatternPart> buildPattern(String strg_pattern, AccoladeArgumentFactory patternArgumentFactory) throws ParseException {
        boolean intoBrace = false;
        ArrayList<PatternPart> partsList = new ArrayList<PatternPart>();
        StringBuilder buf = new StringBuilder();
        boolean inQuote = false;
        block4: for (int i = 0; i < strg_pattern.length(); ++i) {
            char ch = strg_pattern.charAt(i);
            if (inQuote) {
                if (ch == '\'') {
                    if (i + 1 < strg_pattern.length() && strg_pattern.charAt(i + 1) == '\'') {
                        buf.append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = false;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (!intoBrace) {
                if (ch == '\'') {
                    if (i + 1 < strg_pattern.length() && strg_pattern.charAt(i + 1) == '\'') {
                        buf.append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = true;
                    continue;
                }
                if (ch == '{') {
                    intoBrace = true;
                    buf = this.flushTextPatternPartBuffer(partsList, buf);
                    continue;
                }
                if (ch == '}') {
                    throw new ParseException("Unmatched braces in the pattern at position", i);
                }
                buf.append(ch);
                continue;
            }
            switch (ch) {
                case '{': {
                    throw new ParseException("Unmatched braces in the pattern at position", i);
                }
                case '}': {
                    intoBrace = false;
                    buf = this.flushArgumentPatternPartBuffer(partsList, buf, patternArgumentFactory);
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        if (intoBrace) {
            throw new ParseException("Unmatched braces in the pattern (brace not closed).", strg_pattern.length() - 1);
        }
        this.flushTextPatternPartBuffer(partsList, buf);
        return partsList;
    }

    private StringBuilder flushArgumentPatternPartBuffer(List<PatternPart> list, StringBuilder buf, AccoladeArgumentFactory patternArgumentFactory) {
        String name = buf.toString().trim();
        String mode = null;
        int idx = name.indexOf(33);
        if (idx != -1) {
            mode = name.substring(idx + 1).trim();
            if (mode.length() == 0) {
                mode = null;
            }
            name = name.substring(0, idx).trim();
        }
        if (name.length() > 0) {
            AccoladeArgument patternArgument = patternArgumentFactory.getAccoladeArgument(name, mode);
            if (patternArgument != null) {
                list.add(this.newArgumentPatternPart(patternArgument));
            } else {
                list.add(new PatternPart(AccoladePattern.toString(name, mode)));
            }
        } else {
            list.add(new PatternPart(AccoladePattern.toString(name, mode)));
        }
        return new StringBuilder();
    }

    private StringBuilder flushTextPatternPartBuffer(List<PatternPart> list, StringBuilder buf) {
        String strg = buf.toString();
        this.bufferSize += strg.length();
        if (strg.length() > 0) {
            list.add(new PatternPart(strg));
        }
        return new StringBuilder();
    }

    public String toString() {
        return this.patternString;
    }

    public static String toString(String name, String mode) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(name);
        if (mode != null) {
            buf.append('!');
            buf.append(mode);
        }
        buf.append('}');
        return buf.toString();
    }

    public static String toString(AccoladeArgument patternArgument) {
        return AccoladePattern.toString(patternArgument.getName(), patternArgument.getMode());
    }

    private PatternPart newArgumentPatternPart(AccoladeArgument patternArgument) {
        ++this.argumentCount;
        return new PatternPart(patternArgument);
    }

    static class PatternPart {
        AccoladeArgument patternArgument;
        String text;

        PatternPart(String text) {
            this.text = text;
        }

        PatternPart(AccoladeArgument patternArgument) {
            this.patternArgument = patternArgument;
        }

        public boolean isArgumentPart() {
            return this.patternArgument != null;
        }

        public AccoladeArgument getPatternArgument() {
            return this.patternArgument;
        }

        public String getText() {
            return this.text;
        }
    }

    private static class NoneValueResolver
    implements ValueResolver {
        private NoneValueResolver() {
        }

        @Override
        public String getValue(AccoladeArgument accoladeArgument) {
            return AccoladePattern.toString(accoladeArgument);
        }
    }

    private static class DefaultAccoladeArgumentFactory
    implements AccoladeArgumentFactory {
        private DefaultAccoladeArgumentFactory() {
        }

        @Override
        public AccoladeArgument getAccoladeArgument(String name, String mode) {
            return new DefaultAccoladeArgument(name, mode);
        }
    }

    private static class DefaultAccoladeArgument
    implements AccoladeArgument {
        private final String name;
        private final String mode;

        private DefaultAccoladeArgument(String name, String mode) {
            this.name = name;
            this.mode = mode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMode() {
            return this.mode;
        }
    }
}

