/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.instruction;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.text.StringUtils;

public final class InstructionParser {
    private static final int WAITING_FROM_ARGUMENT_END_STEP = 3;
    private static final int WAITING_FROM_KEY_STEP = 4;
    private static final int WAITING_FROM_VALUE_STEP = 5;
    private static final int WAITING_FROM_EQUAL_STEP = 6;
    private static final int KEY_STEP = 7;
    private static final int QUOTED_KEY_STEP = 8;
    private static final int VALUE_STEP = 9;
    private static final int QUOTED_VALUE_STEP = 10;
    private final List<Argument> argumentList = new ArrayList<Argument>();
    private final InstructionErrorHandler errorHandler;
    private ArgumentParser currentArgumentParser;
    private int currentLineNumber = 0;

    private InstructionParser(InstructionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static Instruction parse(String s, InstructionErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = InstructionUtils.DEFAULT_ERROR_HANDLER;
        }
        InstructionParser parser = new InstructionParser(errorHandler);
        return parser.parseInstruction(s);
    }

    private Instruction parseInstruction(String s) {
        this.currentArgumentParser = new ArgumentParser();
        try {
            String line;
            StringReader stringReader = new StringReader(s);
            LineNumberReader bufreader = new LineNumberReader(stringReader);
            while ((line = bufreader.readLine()) != null) {
                try {
                    this.parseLine(line, bufreader.getLineNumber());
                }
                catch (IllegalArgumentException ise) {
                    break;
                }
            }
        }
        catch (IOException stringReader) {
            // empty catch block
        }
        Argument arg = this.currentArgumentParser.toArgument();
        if (arg != null) {
            this.argumentList.add(arg);
        }
        this.currentArgumentParser = null;
        if (this.argumentList.isEmpty()) {
            return null;
        }
        return InstructionUtils.toInstruction(this.argumentList);
    }

    private void parseLine(String line, int lineNumber) {
        this.currentLineNumber = lineNumber;
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            i = this.currentArgumentParser.parseCharAt(line, i);
        }
    }

    private int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    private void endArgument() {
        Argument arg = this.currentArgumentParser.toArgument();
        if (arg != null) {
            this.argumentList.add(arg);
        }
        this.currentArgumentParser = new ArgumentParser();
    }

    private class ArgumentParser {
        private final StringBuilder keyBuffer = new StringBuilder();
        private final StringBuilder valueBuffer = new StringBuilder();
        private boolean previousWhite = false;
        private int step = 4;

        private ArgumentParser() {
        }

        private Argument toArgument() {
            String key = this.keyBuffer.toString();
            if (key.length() == 0) {
                return null;
            }
            return InstructionUtils.toArgument(key, this.valueBuffer.toString());
        }

        private void testWhiteChar(char carac) {
            switch (this.step) {
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 7: {
                    this.step = 6;
                    break;
                }
                case 8: {
                    this.keyBuffer.append(carac);
                    break;
                }
                case 9: {
                    this.previousWhite = true;
                    break;
                }
                case 10: {
                    this.valueBuffer.append(carac);
                }
            }
        }

        private boolean testEnd(char carac) {
            if (carac == ',' || carac == ';') {
                InstructionParser.this.endArgument();
                return true;
            }
            return false;
        }

        private int parseCharAt(String line, int index) {
            char carac = line.charAt(index);
            if (Character.isWhitespace(carac)) {
                this.testWhiteChar(carac);
                return index;
            }
            if (this.step != 8 && this.step != 10 && this.testEnd(carac)) {
                return index;
            }
            switch (this.step) {
                case 3: {
                    this.valueBuffer.append(carac);
                    InstructionParser.this.errorHandler.invalidEndCharacterError(this.valueBuffer.toString(), InstructionParser.this.getCurrentLineNumber(), index);
                    throw new IllegalArgumentException();
                }
                case 4: {
                    if (carac == '\"') {
                        this.step = 8;
                        break;
                    }
                    if (!this.testAsciiChar(carac, index, this.keyBuffer)) break;
                    this.step = 7;
                    break;
                }
                case 6: {
                    if (carac == '=') {
                        this.step = 5;
                        break;
                    }
                    this.keyBuffer.append(carac);
                    InstructionParser.this.errorHandler.invalidSeparatorCharacterError(this.keyBuffer.toString(), InstructionParser.this.getCurrentLineNumber(), index);
                    throw new IllegalArgumentException();
                }
                case 5: {
                    if (carac == '\"') {
                        this.step = 10;
                        break;
                    }
                    if (!this.testAsciiChar(carac, index, this.valueBuffer)) break;
                    this.step = 9;
                    break;
                }
                case 7: {
                    if (carac == '=') {
                        this.step = 5;
                        break;
                    }
                    this.testAsciiChar(carac, index, this.keyBuffer);
                    break;
                }
                case 8: {
                    if (carac == '\"') {
                        this.step = 6;
                        break;
                    }
                    index = this.parseQuoteCharAt(carac, line, index, this.keyBuffer);
                    break;
                }
                case 9: {
                    if (this.previousWhite) {
                        this.valueBuffer.append(' ');
                    }
                    this.testAsciiChar(carac, index, this.valueBuffer);
                    break;
                }
                case 10: {
                    if (carac == '\"') {
                        this.step = 3;
                        break;
                    }
                    index = this.parseQuoteCharAt(carac, line, index, this.valueBuffer);
                }
            }
            this.previousWhite = false;
            return index;
        }

        private boolean testAsciiChar(char carac, int index, StringBuilder buf) {
            if (this.testEnd(carac)) {
                return false;
            }
            if (StringUtils.isValidAsciiChar(carac)) {
                buf.append(carac);
                return true;
            }
            buf.append(carac);
            InstructionParser.this.errorHandler.invalidAsciiCharacterError(buf.toString(), InstructionParser.this.getCurrentLineNumber(), index);
            throw new IllegalArgumentException();
        }

        private int parseQuoteCharAt(char carac, String line, int index, StringBuilder buf) {
            if (carac == '\\') {
                if (index < line.length() - 1) {
                    char next = line.charAt(index + 1);
                    switch (next) {
                        case 'n': {
                            buf.append("\n");
                            break;
                        }
                        case 't': {
                            buf.append("\t");
                            break;
                        }
                        case 'r': {
                            buf.append("\r");
                            break;
                        }
                        default: {
                            buf.append(next);
                        }
                    }
                    ++index;
                }
            } else {
                buf.append(carac);
            }
            return index;
        }
    }
}

