/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.importation;

import java.io.IOException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.importation.LabelImport;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class LabelImportXMLPart
extends XMLPart {
    public LabelImportXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addLabelImport(LabelImport labelImport) throws IOException {
        this.startOpenTag("labelimport");
        this.addAttribute("lang", labelImport.getLang().toString());
        this.endOpenTag();
        List<LabelImport.PhraseImport> fichothequePhaseImportList = labelImport.getFichothequePhraseImportList();
        if (!fichothequePhaseImportList.isEmpty()) {
            this.openTag("fichotheque");
            this.addPhraseImportList(fichothequePhaseImportList);
            this.closeTag("fichotheque");
        }
        for (LabelImport.MetadataImport metadataImport : labelImport.getMetadataImportList()) {
            SubsetKey subsetKey = metadataImport.getSubset().getSubsetKey();
            String tagName = subsetKey.getCategoryString();
            this.startOpenTag(tagName);
            this.addAttribute("name", subsetKey.getSubsetName());
            this.endOpenTag();
            this.addPhraseImportList(metadataImport.getPhraseImportList());
            this.closeTag(tagName);
        }
        for (LabelImport.CorpusImport corpusImport : labelImport.getCorpusImportList()) {
            this.startOpenTag("corpus");
            this.addAttribute("name", corpusImport.getCorpus().getSubsetName());
            this.endOpenTag();
            this.addCorpusLabelImport(corpusImport);
            this.closeTag("corpus");
        }
        this.closeTag("labelimport");
    }

    private void addPhraseImportList(List<LabelImport.PhraseImport> phaseImportList) throws IOException {
        for (LabelImport.PhraseImport phraseImport : phaseImportList) {
            CleanedString value = phraseImport.getLabelString();
            String name = phraseImport.getName();
            if (name == null) {
                this.startOpenTag("title");
            } else {
                this.startOpenTag("phrase");
                this.addAttribute("name", name);
            }
            if (value != null) {
                this.endOpenTag();
                this.addText(value.toString());
                if (name == null) {
                    this.closeTag("title", false);
                    continue;
                }
                this.closeTag("phrase", false);
                continue;
            }
            this.closeEmptyTag();
        }
    }

    private void addCorpusLabelImport(LabelImport.CorpusImport corpusImport) throws IOException {
        CleanedString value;
        for (LabelImport.FieldKeyImport fieldKeyImport : corpusImport.getFieldKeyImportList()) {
            value = fieldKeyImport.getLabelString();
            this.startOpenTag("field");
            this.addAttribute("field-key", fieldKeyImport.getFieldKey().getKeyString());
            if (value != null) {
                this.endOpenTag();
                this.addText(value.toString());
                this.closeTag("field", false);
                continue;
            }
            this.closeEmptyTag();
        }
        for (LabelImport.IncludeKeyImport includeKeyImport : corpusImport.getIncludeKeyImportList()) {
            value = includeKeyImport.getLabelString();
            this.startOpenTag("include");
            this.addAttribute("include-key", includeKeyImport.getIncludeKey().getKeyString());
            if (value != null) {
                this.endOpenTag();
                this.addText(value.toString());
                this.closeTag("include", false);
                continue;
            }
            this.closeEmptyTag();
        }
    }
}

