/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.SwitchException;

public final class MotcleConditionPredicateFactory {
    private static final Test ALWAYS_TEST = new ConstantTest(true);

    private MotcleConditionPredicateFactory() {
    }

    public static Predicate<FicheMeta> newInstance(SelectionContext selectionContext, MotcleCondition motcleCondition) {
        ArrayList<Test> testList = new ArrayList<Test>();
        for (MotcleCondition.Entry entry : motcleCondition.getEntryList()) {
            Test test = MotcleConditionPredicateFactory.toTest(selectionContext, entry);
            if (test == null) continue;
            testList.add(test);
        }
        int size = testList.size();
        Test[] testArray = size == 0 ? new Test[]{ALWAYS_TEST} : testList.toArray(new Test[size]);
        return new ResultPredicate(motcleCondition.getLogicalOperator(), testArray);
    }

    private static Test toTest(SelectionContext selectionContext, MotcleCondition.Entry entry) {
        boolean withSelector;
        MotcleQuery motcleQuery = entry.getMotcleQuery();
        MotcleQuery.ContentCondition contentCondition = motcleQuery.getContentCondition();
        JunctionCondition junctionCondition = entry.getJunctionCondition();
        boolean invert = false;
        boolean withConditions = motcleQuery.hasOtherConditions(false);
        boolean bl = withSelector = junctionCondition != null || withConditions;
        if (contentCondition == null) {
            if (withSelector) {
                return new MotcleSelectorTest(invert, selectionContext, entry);
            }
            if (motcleQuery.isEmpty()) {
                return null;
            }
            return new ThesaurusListTest(invert, selectionContext, entry);
        }
        short conditionType = ConditionsUtils.getConditionType(contentCondition.getTextCondition());
        switch (conditionType) {
            case 2: {
                return new ConstantTest(!invert);
            }
            case 0: 
            case 1: {
                if (withSelector) {
                    return new MotcleSelectorTest(invert, selectionContext, entry);
                }
                return new ConstantTest(invert);
            }
            case 4: {
                if (withSelector) {
                    return new MotcleSelectorTest(invert, selectionContext, entry);
                }
                return new ThesaurusListTest(invert, selectionContext, entry);
            }
            case 3: {
                if (withSelector) {
                    return new MotcleSelectorTest(!invert, selectionContext, entry);
                }
                return new ThesaurusListTest(!invert, selectionContext, entry);
            }
            case 5: 
            case 6: {
                return new ContentTest(invert, selectionContext, entry, conditionType, withSelector);
            }
        }
        throw new SwitchException("state = " + conditionType);
    }

    private static Set<SubsetKey> toSubsetKeySet(Thesaurus[] thesaurusArray) {
        HashSet<SubsetKey> subsetKeySet = new HashSet<SubsetKey>();
        for (Thesaurus thesaurus : thesaurusArray) {
            subsetKeySet.add(thesaurus.getSubsetKey());
        }
        return subsetKeySet;
    }

    private static abstract class Test {
        private final boolean invert;

        protected Test(boolean invert) {
            this.invert = invert;
        }

        public boolean isSelected(FicheMeta ficheMeta) {
            boolean test = this.test(ficheMeta);
            if (this.invert) {
                return !test;
            }
            return test;
        }

        protected abstract boolean test(FicheMeta var1);
    }

    private static class ResultPredicate
    implements Predicate<FicheMeta> {
        private final boolean isOr;
        private final Test[] testArray;

        private ResultPredicate(String logicalOperator, Test[] testArray) {
            this.isOr = logicalOperator.equals("or");
            this.testArray = testArray;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            if (this.isOr) {
                for (Test test : this.testArray) {
                    if (!test.isSelected(ficheMeta)) continue;
                    return true;
                }
                return false;
            }
            for (Test test : this.testArray) {
                if (test.isSelected(ficheMeta)) continue;
                return false;
            }
            return true;
        }
    }

    private static class MotcleSelectorTest
    extends EntryTest {
        private final MotcleSelector motcleSelector;
        private final boolean withJunctionCondition;

        private MotcleSelectorTest(boolean invert, SelectionContext selectionContext, MotcleCondition.Entry entry) {
            super(invert, selectionContext, entry);
            JunctionCondition junctionCondition = entry.getJunctionCondition();
            this.motcleSelector = MotcleSelectorBuilder.init(selectionContext).add(SelectionUtils.deriveWithoutContentCondition(entry.getMotcleQuery()), junctionCondition).toMotcleSelector();
            this.withJunctionCondition = junctionCondition != null;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            Subset masterSubset = this.checkMasterSubset(ficheMeta);
            if (masterSubset != null && this.motcleSelector.test((Motcle)masterSubset.getSubsetItemById(ficheMeta.getId()))) {
                return true;
            }
            for (Thesaurus thesaurus : this.thesaurusArray) {
                Junctions junctions = this.fichotheque.getJunctions(ficheMeta, thesaurus);
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    Motcle motcle = (Motcle)entry.getSubsetItem();
                    if (!(!this.withJunctionCondition ? this.motcleSelector.test(motcle) : this.motcleSelector.isSelected(motcle, entry.getJunction()) != null)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class ThesaurusListTest
    extends EntryTest {
        private ThesaurusListTest(boolean invert, SelectionContext selectionContext, MotcleCondition.Entry entry) {
            super(invert, selectionContext, entry);
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            if (this.checkMasterSubset(ficheMeta) != null) {
                return true;
            }
            for (Thesaurus thesaurus : this.thesaurusArray) {
                Junctions junctions = this.fichotheque.getJunctions(ficheMeta, thesaurus);
                if (junctions.isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    private static class ConstantTest
    extends Test {
        public ConstantTest(boolean constant) {
            super(constant);
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return true;
        }
    }

    private static class ContentTest
    extends EntryTest {
        private final TextTestEngine textTestEngine;
        private final boolean allowsEmpty;
        private final boolean withSelector;
        private final MotcleSelector motcleSelector;
        private final boolean withJunctionCondition;
        private final String contentScope;

        public ContentTest(boolean invert, SelectionContext selectionContext, MotcleCondition.Entry entry, int conditionType, boolean withSelector) {
            super(invert, selectionContext, entry);
            MotcleQuery motcleQuery = entry.getMotcleQuery();
            MotcleQuery.ContentCondition contentCondition = motcleQuery.getContentCondition();
            JunctionCondition junctionCondition = entry.getJunctionCondition();
            this.textTestEngine = TextTestEngine.newInstance(contentCondition.getTextCondition(), selectionContext.getWorkingLang());
            this.allowsEmpty = !withSelector && conditionType == 6;
            this.withSelector = withSelector;
            this.motcleSelector = withSelector ? MotcleSelectorBuilder.init(selectionContext).add(SelectionUtils.deriveWithoutContentCondition(motcleQuery), junctionCondition).toMotcleSelector() : null;
            this.withJunctionCondition = junctionCondition != null;
            this.contentScope = contentCondition.getScope();
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            Motcle motcle;
            boolean empty = true;
            this.textTestEngine.start();
            Subset masterSubset = this.checkMasterSubset(ficheMeta);
            if (masterSubset != null && this.checkSelector(motcle = (Motcle)masterSubset.getSubsetItemById(ficheMeta.getId()), null)) {
                empty = false;
                this.checkTextTest(motcle);
                if (this.textTestEngine.canStop()) {
                    return this.textTestEngine.getResult();
                }
            }
            for (Thesaurus thesaurus : this.thesaurusArray) {
                Junctions junctions = this.fichotheque.getJunctions(ficheMeta, thesaurus);
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    Motcle motcle2 = (Motcle)entry.getSubsetItem();
                    if (!this.checkSelector(motcle2, entry.getJunction())) continue;
                    empty = false;
                    this.checkTextTest(motcle2);
                    if (!this.textTestEngine.canStop()) continue;
                    return this.textTestEngine.getResult();
                }
            }
            if (empty) {
                return this.allowsEmpty;
            }
            return this.textTestEngine.getResult();
        }

        private boolean checkSelector(Motcle motcle, Junction junction) {
            if (!this.withSelector) {
                return true;
            }
            if (junction == null || !this.withJunctionCondition) {
                return this.motcleSelector.test(motcle);
            }
            return this.motcleSelector.isSelected(motcle, junction) != null;
        }

        private void checkTextTest(Motcle motcle) {
            String labelString;
            String idalpha;
            if (!this.contentScope.equals("idalpha_without") && (idalpha = motcle.getIdalpha()) != null) {
                this.textTestEngine.addString(idalpha);
                if (this.contentScope.equals("idalpha_only")) {
                    return;
                }
            }
            if (!(labelString = motcle.getLabelString(this.textTestEngine.getLang(), "")).isEmpty()) {
                this.textTestEngine.addString(labelString);
            }
        }
    }

    private static abstract class EntryTest
    extends Test {
        protected final Fichotheque fichotheque;
        protected final Thesaurus[] thesaurusArray;
        protected final Set<SubsetKey> subsetKeySet;
        protected final boolean withMasterTest;

        public EntryTest(boolean invert, SelectionContext selectionContext, MotcleCondition.Entry entry) {
            super(invert);
            this.fichotheque = selectionContext.getFichotheque();
            this.thesaurusArray = SelectionUtils.toThesaurusArray(this.fichotheque, entry.getMotcleQuery().getThesaurusCondition(), selectionContext.getSubsetAccessPredicate());
            this.withMasterTest = entry.isWithMaster();
            this.subsetKeySet = this.withMasterTest ? MotcleConditionPredicateFactory.toSubsetKeySet(this.thesaurusArray) : null;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return true;
        }

        public Subset checkMasterSubset(FicheMeta ficheMeta) {
            if (!this.withMasterTest) {
                return null;
            }
            Subset masterSubset = ficheMeta.getCorpus().getMasterSubset();
            if (masterSubset == null) {
                return null;
            }
            if (this.subsetKeySet.contains(masterSubset.getSubsetKey())) {
                return masterSubset;
            }
            return null;
        }
    }
}

