/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus.sync;

import java.util.HashMap;
import java.util.Map;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.sync.MotcleSync;
import net.fichotheque.thesaurus.sync.ThesaurusSync;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.tools.thesaurus.sync.SyncScanResult;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.text.LabelChange;

public class SyncScan {
    private final Thesaurus destinationThesaurus;
    private final ThesaurusSync originThesaurus;
    private final Map<String, Motcle> missingIdalpha = new HashMap<String, Motcle>();
    private final EditThesaurusImportBuilder changeBuilder;
    private final EditThesaurusImportBuilder creationBuilder;

    private SyncScan(ThesaurusSync originThesaurus, Thesaurus destinationThesaurus) {
        this.originThesaurus = originThesaurus;
        this.destinationThesaurus = destinationThesaurus;
        this.changeBuilder = new EditThesaurusImportBuilder(destinationThesaurus);
        this.creationBuilder = new EditThesaurusImportBuilder(destinationThesaurus);
    }

    private void run() {
        for (Motcle motcle : this.destinationThesaurus.getMotcleList()) {
            this.missingIdalpha.put(motcle.getIdalpha(), motcle);
        }
        for (MotcleSync originMotcle : this.originThesaurus.getMotcleSyncList()) {
            String idalpha = originMotcle.getIdalpha();
            Motcle destinationMotcle = this.destinationThesaurus.getMotcleByIdalpha(idalpha);
            if (destinationMotcle != null) {
                this.missingIdalpha.remove(idalpha);
                this.sync(originMotcle, destinationMotcle);
                continue;
            }
            this.create(originMotcle);
        }
        this.checkRemoved();
    }

    private void create(MotcleSync origin) {
        AttributeChange attributeChange;
        String newIdalpha = origin.getIdalpha();
        EditMotcleImportBuilder motcleImportBuilder = this.creationBuilder.getEditMotcleImportBuilder(-1, newIdalpha);
        motcleImportBuilder.setNewStatus(origin.getStatus());
        LabelChange labelChange = origin.getLabelChange();
        if (labelChange != null) {
            motcleImportBuilder.getLabelChangeBuilder().putLabels(labelChange.getChangedLabels());
        }
        if ((attributeChange = origin.getAttributeChange()) != null) {
            motcleImportBuilder.getAttributeChangeBuilder().changeAttributes(attributeChange);
        }
    }

    private void sync(MotcleSync origin, Motcle destination) {
        AttributeChange attributeChange;
        LabelChange labelChange;
        EditMotcleImportBuilder motcleImportBuilder = this.changeBuilder.getEditMotcleImportBuilder(destination);
        if (!origin.getStatus().equals(destination.getStatus())) {
            motcleImportBuilder.setNewStatus(origin.getStatus());
        }
        if ((labelChange = origin.getLabelChange()) != null) {
            motcleImportBuilder.getLabelChangeBuilder().filterRealChanges(destination.getLabels(), labelChange);
        }
        if ((attributeChange = origin.getAttributeChange()) != null) {
            motcleImportBuilder.getAttributeChangeBuilder().filterRealChanges(destination.getAttributes(), attributeChange, AttributeUtils.NONE_PREDICATE);
        }
    }

    private void checkRemoved() {
        for (Map.Entry<String, Motcle> entry : this.missingIdalpha.entrySet()) {
            Motcle motcle = entry.getValue();
            if (motcle.getStatus().equals("obsolete")) continue;
            EditMotcleImportBuilder motcleImportBuilder = this.changeBuilder.getEditMotcleImportBuilder(motcle);
            motcleImportBuilder.setNewStatus("obsolete");
        }
    }

    private SyncScanResult computeResult() {
        return SyncScanResult.init().setChangeImport(this.changeBuilder.toThesaurusImport()).setCreationImport(this.creationBuilder.toThesaurusImport());
    }

    public static SyncScanResult scanThesaurusImport(ThesaurusSync originThesaurus, Thesaurus destinationThesaurus) {
        SyncScan engine = new SyncScan(originThesaurus, destinationThesaurus);
        engine.run();
        return engine.computeResult();
    }
}

