/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fichotheque.tools.parsers.junction.TokenKey;

public class TokenKeys {
    public static final String DOCUMENT_REF = "document_ref";
    public static final String DOCUMENT_FILE = "document_file";
    public static final String ILLUSTRATION_REF = "illustration_ref";
    public static final String ILLUSTRATION_FILE = "illustration_file";
    private final List<TokenKey> documentRefList = new ArrayList<TokenKey>();
    private final List<TokenKey> documentFileList = new ArrayList<TokenKey>();
    private final List<TokenKey> illustrationRefList = new ArrayList<TokenKey>();
    private final List<TokenKey> illustrationFileList = new ArrayList<TokenKey>();

    private TokenKeys() {
    }

    public List<TokenKey> getTokenKeyList(String name) {
        switch (name) {
            case "document_ref": {
                return this.documentRefList;
            }
            case "document_file": {
                return this.documentFileList;
            }
            case "illustration_ref": {
                return this.illustrationRefList;
            }
            case "illustration_file": {
                return this.illustrationFileList;
            }
        }
        return null;
    }

    public boolean withIllustration() {
        return !this.illustrationFileList.isEmpty() || !this.illustrationRefList.isEmpty();
    }

    public boolean withDocument() {
        return !this.documentFileList.isEmpty() || !this.documentRefList.isEmpty();
    }

    public static TokenKeys build(Set<String> paramNameSet) {
        TokenKeys tokenKeys = new TokenKeys();
        for (String paramName : paramNameSet) {
            try {
                TokenKey tokenKey = TokenKey.parse(paramName);
                short category = tokenKey.getIncludeKey().getSubsetKey().getCategory();
                if (category == 5) {
                    if (tokenKey.getSubname().equals("file")) {
                        tokenKeys.illustrationFileList.add(tokenKey);
                        continue;
                    }
                    tokenKeys.illustrationRefList.add(tokenKey);
                    continue;
                }
                if (category != 4) continue;
                if (tokenKey.getSubname().equals("file")) {
                    tokenKeys.documentFileList.add(tokenKey);
                    continue;
                }
                tokenKeys.documentRefList.add(tokenKey);
            }
            catch (ParseException parseException) {}
        }
        return tokenKeys;
    }
}

