/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumConstants;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.IllustrationMultipartToken;
import net.fichotheque.tools.parsers.junction.IllustrationRemoveToken;
import net.fichotheque.tools.parsers.junction.TokenKey;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.StringUtils;

public class IllustrationTokenParser {
    private final SubsetItem mainSubsetItem;
    private final List<IllustrationRemoveToken> illustrationRemoveTokenList = new ArrayList<IllustrationRemoveToken>();
    private final List<IllustrationMultipartToken> multipartTokenList = new ArrayList<IllustrationMultipartToken>();
    private final List<TmpFileToken> tmpFileTokenList = new ArrayList<TmpFileToken>();
    private final Set<Illustration> removeSet = new HashSet<Illustration>();
    private final List<UpdateToken> updateTokenList = new ArrayList<UpdateToken>();
    private final File tmpDirectory;

    public IllustrationTokenParser(SubsetItem mainSubsetItem, File tmpDirectory) {
        this.mainSubsetItem = mainSubsetItem;
        this.tmpDirectory = tmpDirectory;
    }

    public void addFromMultipart(TokenKey subtokenParameter, FileValue[] fileValues) {
        IncludeKey includeKey = subtokenParameter.getIncludeKey();
        SubsetKey albumKey = includeKey.getSubsetKey();
        if (!albumKey.isAlbumSubset()) {
            throw new IllegalArgumentException("not an album Parameter: " + subtokenParameter.getParamName());
        }
        Album album = (Album)this.mainSubsetItem.getFichotheque().getSubset(albumKey);
        if (album == null) {
            return;
        }
        String mode = includeKey.getMode();
        int weight = includeKey.getWeightFilter();
        for (FileValue fileValue : fileValues) {
            FileName fileName;
            if (fileValue.length() < 1L) {
                fileValue.free();
                continue;
            }
            String extension = null;
            try {
                fileName = FileName.parse(fileValue.getName(), "octetstream");
                extension = AlbumUtils.checkExtension(fileName.toString());
                if (extension == null) {
                    fileName = null;
                }
            }
            catch (ParseException pe) {
                fileName = null;
            }
            if (fileName == null) {
                fileValue.free();
                continue;
            }
            this.multipartTokenList.add(new IllustrationMultipartToken(album, extension, mode, weight, fileValue));
        }
    }

    public void parse(TokenKey tokenKey, String[] parameterValues) {
        IncludeKey includeKey = tokenKey.getIncludeKey();
        SubsetKey albumKey = includeKey.getSubsetKey();
        if (!albumKey.isAlbumSubset()) {
            throw new IllegalArgumentException("not an album Parameter: " + tokenKey.getParamName());
        }
        Album album = (Album)this.mainSubsetItem.getFichotheque().getSubset(albumKey);
        if (album == null) {
            return;
        }
        String[] values = IllustrationTokenParser.tokenize(parameterValues);
        if (values.length == 0) {
            return;
        }
        String subname = tokenKey.getSubname();
        if (subname.equals("create")) {
            int weightFilter = includeKey.getWeightFilter();
            String mode = includeKey.getMode();
            for (String value : values) {
                TmpFileToken tmpFileToken = new TmpFileToken(value, album, mode, weightFilter);
                this.tmpFileTokenList.add(tmpFileToken);
            }
        } else if (subname.equals("remove")) {
            for (String value : values) {
                IllustrationRemoveToken illustrationRemoveToken = IllustrationRemoveToken.parse(value, album, includeKey);
                if (illustrationRemoveToken == null) continue;
                this.illustrationRemoveTokenList.add(illustrationRemoveToken);
                this.removeSet.add(illustrationRemoveToken.getIllustration());
            }
        } else if (subname.equals("update")) {
            for (String value : values) {
                int sepIndex = value.indexOf(61);
                if (sepIndex == -1) continue;
                try {
                    int illustrationid = Integer.parseInt(value.substring(0, sepIndex));
                    Illustration illustration = album.getIllustrationById(illustrationid);
                    if (illustration == null) continue;
                    String tmpFileName = value.substring(sepIndex + 1);
                    this.updateTokenList.add(new UpdateToken(illustration, tmpFileName));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown action: '" + subname + "', not an album Parameter: " + tokenKey.getParamName());
        }
    }

    private static String[] tokenize(String[] values) {
        LinkedHashSet<String> tokenSet = new LinkedHashSet<String>();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            String[] tokens = StringUtils.getTechnicalTokens(values[i], false);
            int tokenCount = tokens.length;
            for (int j = 0; j < tokenCount; ++j) {
                tokenSet.add(tokens[j]);
            }
        }
        return tokenSet.toArray(new String[tokenSet.size()]);
    }

    public void save(FichothequeEditor fichothequeEditor) {
        JunctionEditor junctionEditor = fichothequeEditor.getJunctionEditor();
        for (UpdateToken updateToken : this.updateTokenList) {
            updateToken.updateIllustration(fichothequeEditor);
        }
        if (!(this.tmpFileTokenList.isEmpty() && this.multipartTokenList.isEmpty() && this.illustrationRemoveTokenList.isEmpty())) {
            TieBuffer tieBuffer;
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendOrWeightReplaceEngine(this.mainSubsetItem);
            for (IllustrationRemoveToken illustrationRemoveToken : this.illustrationRemoveTokenList) {
                junctionChangeEngine.removeTie(illustrationRemoveToken.getIllustration(), illustrationRemoveToken.getMode());
            }
            for (IllustrationMultipartToken illustrationMultipartToken : this.multipartTokenList) {
                tieBuffer = illustrationMultipartToken.createIllustration(fichothequeEditor);
                if (tieBuffer == null) continue;
                junctionChangeEngine.addTie(tieBuffer);
            }
            for (TmpFileToken tmpFileToken : this.tmpFileTokenList) {
                tieBuffer = tmpFileToken.createIllustration(fichothequeEditor);
                if (tieBuffer == null) continue;
                junctionChangeEngine.addTie(tieBuffer);
            }
            junctionEditor.updateJunctions(this.mainSubsetItem, junctionChangeEngine.toJunctionChanges());
        }
        for (Illustration illustration : this.removeSet) {
            fichothequeEditor.getAlbumEditor(illustration.getSubsetKey()).removeIllustration(illustration);
        }
    }

    private class TmpFileToken {
        private final int weight;
        private final String mode;
        private final String tmpFileName;
        private final Album album;

        private TmpFileToken(String tmpFileName, Album album, String mode, int weight) {
            this.weight = weight > 1 ? weight : 1;
            this.mode = mode;
            this.album = album;
            this.tmpFileName = tmpFileName;
        }

        private TieBuffer createIllustration(FichothequeEditor fichothequeEditor) {
            Illustration illustration;
            AlbumEditor albumEditor = fichothequeEditor.getAlbumEditor(this.album);
            if (albumEditor == null) {
                return null;
            }
            int idx = this.tmpFileName.lastIndexOf(".");
            String extension = this.tmpFileName.substring(idx + 1);
            File f = new File(IllustrationTokenParser.this.tmpDirectory, this.tmpFileName);
            if (!f.exists()) {
                return null;
            }
            String formatType = AlbumConstants.checkFormatType(extension);
            try {
                illustration = albumEditor.createIllustration(-1, formatType);
            }
            catch (ExistingIdException eie) {
                throw new ShouldNotOccurException(eie);
            }
            try (FileInputStream is = new FileInputStream(f);){
                albumEditor.updateIllustration(illustration, is, formatType);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            catch (ErrorMessageException errorMessageException) {
                // empty catch block
            }
            return new TieBuffer(illustration, this.mode, this.weight);
        }
    }

    private class UpdateToken {
        private final Illustration illustration;
        private final String tmpFileName;

        private UpdateToken(Illustration illustration, String tmpFileName) {
            this.illustration = illustration;
            this.tmpFileName = tmpFileName;
        }

        private void updateIllustration(FichothequeEditor fichothequeEditor) {
            AlbumEditor albumEditor = fichothequeEditor.getAlbumEditor(this.illustration.getSubsetKey());
            int idx = this.tmpFileName.lastIndexOf(".");
            String extension = this.tmpFileName.substring(idx + 1);
            File f = new File(IllustrationTokenParser.this.tmpDirectory, this.tmpFileName);
            if (!f.exists()) {
                return;
            }
            String formatType = AlbumConstants.checkFormatType(extension);
            try (FileInputStream is = new FileInputStream(f);){
                albumEditor.updateIllustration(this.illustration, is, formatType);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            catch (ErrorMessageException errorMessageException) {
                // empty catch block
            }
        }
    }
}

