/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.def.GroupParams;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.utils.ExtractionUtils;

public class GroupClauseBuilder {
    private final String groupType;
    private String sortOrder = "asc";
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private GroupParams groupParams = null;
    private GroupClause subGroupClause = null;

    public GroupClauseBuilder(String groupType) {
        this.groupType = groupType;
    }

    public GroupClauseBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public GroupClauseBuilder setSortOrder(String sortOrder) {
        this.sortOrder = ExtractionUtils.checkSort(sortOrder);
        return this;
    }

    public GroupClauseBuilder setGroupParams(GroupParams groupParams) {
        this.groupParams = groupParams;
        return this;
    }

    public GroupClauseBuilder setSubGroupClause(GroupClause groupClause) {
        this.subGroupClause = groupClause;
        return this;
    }

    public GroupClause toGroupClause() {
        switch (this.groupType) {
            case "fields": {
                if (this.groupParams != null) break;
                throw new IllegalStateException("groupParams is null");
            }
        }
        return new InternalGroupClause(this.groupType, this.sortOrder, this.tagNameInfo, this.groupParams, this.subGroupClause);
    }

    public static GroupClauseBuilder init(String groupType) {
        return new GroupClauseBuilder(groupType);
    }

    public static GroupClause getGroupClause(String groupClauseString, boolean hidden) {
        String type;
        int idx = groupClauseString.indexOf(45);
        if (idx == -1) {
            return null;
        }
        try {
            type = ExtractionUtils.checkType(groupClauseString.substring(0, idx));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        String sortOrder = ExtractionUtils.checkSort(groupClauseString.substring(idx + 1));
        switch (type) {
            case "weight": 
            case "title": 
            case "year": 
            case "lang": 
            case "position": {
                break;
            }
            default: {
                return null;
            }
        }
        TagNameInfo tagNameInfo = hidden ? TagNameInfo.NULL : TagNameInfo.DEFAULT;
        return new InternalGroupClause(type, sortOrder, tagNameInfo, null, null);
    }

    private static class InternalGroupClause
    implements GroupClause {
        private final String groupType;
        private final String sortOrder;
        private final TagNameInfo tagNameInfo;
        private final GroupParams groupParams;
        private final GroupClause subGroupClause;

        private InternalGroupClause(String groupType, String sortOrder, TagNameInfo tagNameInfo, GroupParams groupParams, GroupClause subGroupClause) {
            this.groupType = groupType;
            this.sortOrder = sortOrder;
            this.tagNameInfo = tagNameInfo;
            this.groupParams = groupParams;
            this.subGroupClause = subGroupClause;
        }

        @Override
        public String getGroupType() {
            return this.groupType;
        }

        @Override
        public String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public GroupParams getGroupParams() {
            return this.groupParams;
        }

        @Override
        public GroupClause getSubGroupClause() {
            return this.subGroupClause;
        }
    }
}

