/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.scrutari;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.junction.Liaison;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.tools.exportation.scrutari.ExportInclude;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportUtils;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.tools.exportation.table.TableDefParser;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.hook.HookHandler;
import net.mapeadores.util.hook.HookUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValueResolver;
import net.scrutari.dataexport.ScrutariDataExportFactory;
import net.scrutari.dataexport.api.BaseMetadataExport;
import net.scrutari.dataexport.api.CorpusMetadataExport;
import net.scrutari.dataexport.api.FicheExport;
import net.scrutari.dataexport.api.MotcleExport;
import net.scrutari.dataexport.api.ScrutariDataExport;
import net.scrutari.dataexport.api.ThesaurusMetadataExport;

public final class ScrutariExportEngine {
    private final TableExportContext tableExportContext;
    private final Fichotheque fichotheque;
    private final FormatContext formatContext;
    private final ScrutariExportDef scrutariExportDef;
    private final Lang[] langArray;
    private final ExtractionContext extractionContext;
    private final Predicate<SubsetItem> predicate;
    private final ThesaurusLangChecker thesaurusLangChecker;
    private final HookHandler hookHandler;
    private ScrutariDataExport scrutariDataExport;
    private ThesaurusEngine[] thesaurusEngineArray;

    private ScrutariExportEngine(ScrutariExportDef scrutariExportDef, Lang[] langArray, ExtractionContext extractionContext, TableExportContext tableExportContext, Predicate<SubsetItem> predicate, ThesaurusLangChecker thesaurusLangChecker, HookHandler hookHandler) {
        this.scrutariExportDef = scrutariExportDef;
        this.langArray = langArray;
        this.extractionContext = extractionContext;
        this.tableExportContext = tableExportContext;
        this.formatContext = tableExportContext.getFormatContext();
        this.fichotheque = this.formatContext.getFichotheque();
        this.predicate = predicate;
        this.thesaurusLangChecker = thesaurusLangChecker;
        this.hookHandler = hookHandler;
    }

    public static ScrutariExportEngine build(ScrutariExportDef scrutariExportDef, Lang[] langArray, ExtractionContext extractionContext, TableExportContext tableExportContext, ThesaurusLangChecker thesaurusLangChecker, @Nullable HookHandler hookHandler, FichothequeQueries resolvedFichothequeQueries) {
        if (langArray.length == 0) {
            throw new IllegalArgumentException("langArray.length == 0");
        }
        FormatContext formatContext = tableExportContext.getFormatContext();
        SelectionContext selectionContext = SelectionContextBuilder.init(formatContext.getFichotheque(), extractionContext.getFichothequeQuestioner(), formatContext.getMessageLocalisationProvider(), langArray[0]).setSubsetAccessPredicate(EligibilityUtils.ALL_SUBSET_PREDICATE).toSelectionContext();
        FicheSelectorBuilder ficheSelectorBuilder = FicheSelectorBuilder.init(selectionContext);
        for (FicheQuery ficheQuery : resolvedFichothequeQueries.getFicheQueryList()) {
            ficheSelectorBuilder.add(ficheQuery);
        }
        Predicate<SubsetItem> globalPredicate = EligibilityUtils.merge(SelectionUtils.toPredicate(ficheSelectorBuilder.toFicheSelector()), null);
        tableExportContext = ScrutariExportUtils.toScrutariTableExportContext(tableExportContext);
        if (hookHandler == null) {
            hookHandler = HookUtils.NONE_HANDLER;
        }
        return new ScrutariExportEngine(scrutariExportDef, langArray, extractionContext, tableExportContext, globalPredicate, thesaurusLangChecker, hookHandler);
    }

    public void run(Appendable appendable, int indentLength, boolean includeXMLDeclaration) throws IOException {
        this.scrutariDataExport = ScrutariDataExportFactory.newInstance(appendable, indentLength, includeXMLDeclaration, true);
        this.thesaurusEngineArray = this.initThesaurusEngineArray();
        BaseMetadataExport basemetaDataExport = this.scrutariDataExport.startExport();
        this.addBaseMetadata(basemetaDataExport);
        CorpusEngine[] corpusEngineArray = this.initCorpusEngineArray();
        for (CorpusEngine corpusEngine : corpusEngineArray) {
            corpusEngine.run();
        }
        if (this.thesaurusEngineArray != null) {
            for (ThesaurusEngine thesaurusEngine : this.thesaurusEngineArray) {
                thesaurusEngine.addThesaurus();
            }
        }
        this.hookHandler.handle("End", this.scrutariDataExport);
        this.scrutariDataExport.endExport();
    }

    private CorpusEngine[] initCorpusEngineArray() {
        Map<SubsetKey, CorpusScrutariDef> corpusDefMap = ScrutariExportUtils.toCorpusScrutariDefMap(this.scrutariExportDef);
        ArrayList<CorpusEngine> selectedList = new ArrayList<CorpusEngine>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            CorpusScrutariDef corpusScrutariDef = corpusDefMap.get(corpus.getSubsetKey());
            if (corpusScrutariDef == null) continue;
            selectedList.add(this.initCorpusEngine(corpus, corpusScrutariDef));
        }
        return selectedList.toArray(new CorpusEngine[selectedList.size()]);
    }

    private ThesaurusEngine[] initThesaurusEngineArray() {
        Map<SubsetKey, ThesaurusScrutariDef> thesaurusDefMap = ScrutariExportUtils.toThesaurusScrutariDefMap(this.scrutariExportDef);
        ArrayList<ThesaurusEngine> selectedList = new ArrayList<ThesaurusEngine>();
        for (Thesaurus thesaurus : this.fichotheque.getThesaurusList()) {
            ThesaurusScrutariDef thesaurusScrutariDef = thesaurusDefMap.get(thesaurus.getSubsetKey());
            if (thesaurusScrutariDef == null) continue;
            selectedList.add(this.initThesaurusEngine(thesaurus, thesaurusScrutariDef));
        }
        return selectedList.toArray(new ThesaurusEngine[selectedList.size()]);
    }

    private void addBaseMetadata(BaseMetadataExport basemetaDataExport) throws IOException {
        basemetaDataExport.setAuthority(this.scrutariExportDef.getAuthority());
        basemetaDataExport.setBaseName(this.scrutariExportDef.getBaseName());
        basemetaDataExport.setBaseIcon(this.scrutariExportDef.getBaseIcon());
        FichothequeMetadata fichothequeMetadata = this.fichotheque.getFichothequeMetadata();
        this.addIntitule(basemetaDataExport, fichothequeMetadata, 1);
        this.addIntitule(basemetaDataExport, fichothequeMetadata, 2);
        for (Lang lang : this.scrutariExportDef.getUiLangs()) {
            basemetaDataExport.addLangUI(lang.toString());
        }
        ExportInclude exportInclude = ExportInclude.parse(this.scrutariExportDef.getIncludeTokenList());
        if (exportInclude.isWithAttributeFilter()) {
            Predicate<AttributeKey> attributeFilter = exportInclude.getAttributeFilter();
            for (Attribute attribute : fichothequeMetadata.getAttributes()) {
                AttributeKey attributeKey = attribute.getAttributeKey();
                if (!attributeFilter.test(attributeKey)) continue;
                for (String value : attribute) {
                    basemetaDataExport.addAttributeValue(attributeKey.getNameSpace(), attributeKey.getLocalKey(), value);
                }
            }
        }
        this.hookHandler.handle("BaseMetadata", basemetaDataExport, fichothequeMetadata, exportInclude.getHookList());
    }

    private void addIntitule(BaseMetadataExport basemetaDataExport, FichothequeMetadata fichothequeMetadata, int intituleType) {
        Labels labels = this.scrutariExportDef.getCustomBaseIntitule(intituleType);
        if (labels == null) {
            labels = intituleType == 1 ? fichothequeMetadata.getTitleLabels() : fichothequeMetadata.getPhrases().getPhrase("long");
        }
        boolean done = false;
        if (labels != null) {
            int length = this.langArray.length;
            for (int i = 0; i < length; ++i) {
                Label label = labels.getLabel(this.langArray[i]);
                if (label == null) continue;
                basemetaDataExport.setIntitule(intituleType, label.getLang().toString(), label.getLabelString());
                done = true;
            }
        }
        if (!done) {
            basemetaDataExport.setIntitule(intituleType, "und", this.scrutariExportDef.getBaseName());
        }
    }

    private CorpusEngine initCorpusEngine(Corpus corpus, CorpusScrutariDef corpusScrutariDef) {
        SourceFormatter titreFormatter = null;
        SourceFormatter soustitreFormatter = null;
        SourceFormatter dateFormatter = null;
        SourceFormatter hrefFormatter = null;
        SourceFormatter ficheIconFormatter = null;
        TableDef tableDef = TableDefParser.parse(corpusScrutariDef.getFieldGenerationSource(), (Subset)corpus, this.tableExportContext, LogUtils.NULL_LINEMESSAGEHANDLER, 0);
        SubsetTable subsetTable = SubsetTableBuilder.init(corpus).populate(tableDef, this.tableExportContext, false, "\n").toSubsetTable();
        ArrayList<ComplementEngine> complementEngineList = new ArrayList<ComplementEngine>();
        ArrayList<AttributeEngine> attributeEngineList = new ArrayList<AttributeEngine>();
        List<Col> colList = subsetTable.getColList();
        for (Col col : colList) {
            ColDef colDef = col.getColDef();
            String colName = colDef.getColName();
            SourceFormatter formatter = col.getSourceFormatter();
            if (colName.equals("titre")) {
                if (titreFormatter != null) continue;
                titreFormatter = formatter;
                continue;
            }
            if (colName.equals("soustitre")) {
                if (soustitreFormatter != null) continue;
                soustitreFormatter = formatter;
                continue;
            }
            if (colName.equals("date")) {
                if (dateFormatter != null) continue;
                dateFormatter = formatter;
                continue;
            }
            if (colName.equals("href")) {
                if (hrefFormatter != null) continue;
                hrefFormatter = formatter;
                continue;
            }
            if (colName.equals("ficheicon")) {
                if (ficheIconFormatter != null) continue;
                ficheIconFormatter = formatter;
                continue;
            }
            if (colName.startsWith("comp")) {
                ComplementEngine complementEngine = new ComplementEngine(formatter);
                Labels customLabels = colDef.getCustomLabels();
                if (customLabels != null) {
                    complementEngine.setCustomLabels(customLabels);
                } else if (colDef instanceof FormatColDef) {
                    complementEngine.setDefaultLabels(this.tableExportContext.getSourceLabelProvider().getLabels(corpus, ((FormatColDef)colDef).getFichothequeFormatDef().getFormatSourceKeyList().get(0)), this.langArray);
                }
                complementEngineList.add(complementEngine);
                continue;
            }
            try {
                AttributeKey attributeKey = AttributeKey.parse(colName);
                attributeEngineList.add(new AttributeEngine(attributeKey, formatter));
            }
            catch (ParseException parseException) {}
        }
        ComplementEngine[] complementEngineArray = complementEngineList.toArray(new ComplementEngine[complementEngineList.size()]);
        AttributeEngine[] attributeEngineArray = attributeEngineList.toArray(new AttributeEngine[attributeEngineList.size()]);
        if (titreFormatter == null) {
            titreFormatter = ScrutariExportUtils.TITRE;
        }
        if (soustitreFormatter == null) {
            soustitreFormatter = ScrutariExportUtils.SOUSTITRE;
        }
        if (dateFormatter == null) {
            dateFormatter = this.getDefaultDateFormatter(corpus, corpusScrutariDef);
        }
        if (hrefFormatter == null) {
            hrefFormatter = this.getDefaultHrefFormatter(corpusScrutariDef);
        }
        if (ficheIconFormatter == null) {
            ficheIconFormatter = ScrutariExportUtils.NULL;
        }
        return new CorpusEngine(corpus, corpusScrutariDef, titreFormatter, soustitreFormatter, dateFormatter, hrefFormatter, ficheIconFormatter, complementEngineArray, attributeEngineArray);
    }

    private SourceFormatter getDefaultHrefFormatter(CorpusScrutariDef corpusScrutariDef) {
        AccoladePattern hrefPattern = corpusScrutariDef.getHrefPattern();
        if (hrefPattern == null) {
            hrefPattern = this.scrutariExportDef.getFicheHrefPattern();
        }
        if (hrefPattern == null) {
            return ScrutariExportUtils.NULL;
        }
        return new HrefSourceFormatter(hrefPattern);
    }

    private SourceFormatter getDefaultDateFormatter(Corpus corpus, CorpusScrutariDef corpusScrutariDef) {
        FormatSourceKey dateFormatSourceKey = corpusScrutariDef.getDateFormatSourceKey();
        if (dateFormatSourceKey == null) {
            return ScrutariExportUtils.NULL;
        }
        switch (dateFormatSourceKey.getSourceType()) {
            case "field": {
                CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField((FieldKey)dateFormatSourceKey.getKeyObject());
                if (corpusField == null || !corpusField.isType("date")) break;
                return ScrutariExportUtils.getDateFieldFormatter(corpusField.getFieldKey());
            }
            case "specialinclude": {
                String specialIncludeName = (String)dateFormatSourceKey.getKeyObject();
                if (specialIncludeName.equals("date_creation")) {
                    return ScrutariExportUtils.DATE_CREATION;
                }
                if (!specialIncludeName.equals("date_modification")) break;
                return ScrutariExportUtils.DATE_MODIFICATION;
            }
        }
        return ScrutariExportUtils.NULL;
    }

    private ThesaurusEngine initThesaurusEngine(Thesaurus thesaurus, ThesaurusScrutariDef thesaurusScrutariDef) {
        TableDef tableDef = TableDefParser.parse(thesaurusScrutariDef.getFieldGenerationSource(), (Subset)thesaurus, this.tableExportContext, LogUtils.NULL_LINEMESSAGEHANDLER, 0);
        SubsetTable subsetTable = SubsetTableBuilder.init(thesaurus).populate(tableDef, this.tableExportContext, false, "\n").toSubsetTable();
        ArrayList<AttributeEngine> attributeEngineList = new ArrayList<AttributeEngine>();
        List<Col> colList = subsetTable.getColList();
        SourceFormatter labelsFormatter = null;
        for (Col col : colList) {
            ColDef colDef = col.getColDef();
            String colName = colDef.getColName();
            SourceFormatter formatter = col.getSourceFormatter();
            if (colName.equals("labels")) {
                if (labelsFormatter != null) continue;
                labelsFormatter = formatter;
                continue;
            }
            try {
                AttributeKey attributeKey = AttributeKey.parse(colName);
                attributeEngineList.add(new AttributeEngine(attributeKey, formatter));
            }
            catch (ParseException parseException) {}
        }
        AttributeEngine[] attributeEngineArray = attributeEngineList.toArray(new AttributeEngine[attributeEngineList.size()]);
        return new ThesaurusEngine(thesaurus, thesaurusScrutariDef, labelsFormatter, attributeEngineArray);
    }

    private class ThesaurusEngine {
        private final Thesaurus thesaurus;
        private final Set<Integer> idSet = new HashSet<Integer>();
        private final UserLangContext[] langContextArray;
        private final SourceFormatter labelsFormatter;
        private final AttributeEngine[] attributeEngineArray;
        private final MutableFormatSource mutableFormatSource;
        private final boolean wholeThesaurus;
        private final ExportInclude exportInclude;

        private ThesaurusEngine(Thesaurus thesaurus, ThesaurusScrutariDef thesaurusScrutariDef, SourceFormatter labelsFormatter, AttributeEngine[] attributeEngineArray) {
            this.thesaurus = thesaurus;
            this.mutableFormatSource = new MutableFormatSource(PointeurFactory.newMotclePointeur(thesaurus), ScrutariExportEngine.this.extractionContext, ScrutariExportEngine.this.formatContext, ScrutariExportEngine.this.predicate);
            this.wholeThesaurus = thesaurusScrutariDef.isWholeThesaurus();
            Langs authorizedLangs = ScrutariExportEngine.this.thesaurusLangChecker.getAuthorizedLangs(thesaurus);
            if (authorizedLangs != null) {
                int length = authorizedLangs.size();
                this.langContextArray = new UserLangContext[length];
                for (int i = 0; i < length; ++i) {
                    this.langContextArray[i] = LocalisationUtils.toUserLangContext((Lang)authorizedLangs.get(i));
                }
            } else {
                this.langContextArray = null;
            }
            this.attributeEngineArray = attributeEngineArray;
            this.labelsFormatter = labelsFormatter != null ? labelsFormatter : ScrutariExportUtils.getDefaultLabelsFormatter(thesaurus, ScrutariExportEngine.this.tableExportContext);
            this.exportInclude = ExportInclude.parse(thesaurusScrutariDef.getIncludeTokenList());
        }

        private void addId(int id) {
            this.idSet.add(id);
        }

        private Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        private void addThesaurus() {
            if (!this.wholeThesaurus && this.idSet.isEmpty()) {
                return;
            }
            ThesaurusMetadataExport thesaurusMetadataExport = ScrutariExportEngine.this.scrutariDataExport.newThesaurus(this.thesaurus.getSubsetName());
            this.addThesaurusMetadata(thesaurusMetadataExport, this.thesaurus.getThesaurusMetadata());
            for (Motcle motcle : this.thesaurus.getMotcleList()) {
                if (!this.wholeThesaurus && !this.idSet.contains(motcle.getId())) continue;
                this.addMotcle(motcle);
            }
        }

        private void addMotcle(Motcle motcle) {
            MotcleExport motcleExport = ScrutariExportEngine.this.scrutariDataExport.newMotcle(String.valueOf(motcle.getId()));
            this.mutableFormatSource.getSubsetItemPointeur().setCurrentSubsetItem(motcle);
            if (this.langContextArray != null) {
                for (UserLangContext langContext : this.langContextArray) {
                    this.mutableFormatSource.setLangContext(langContext);
                    motcleExport.setLibelle(langContext.getWorkingLang().toString(), this.labelsFormatter.formatSource(this.mutableFormatSource));
                }
            } else {
                Lang lang = motcle.getBabelienLabel().getLang();
                this.mutableFormatSource.setLangContext(LocalisationUtils.toUserLangContext(lang));
                motcleExport.setLibelle(lang.toString(), this.labelsFormatter.formatSource(this.mutableFormatSource));
            }
            for (AttributeEngine attributeEngine : this.attributeEngineArray) {
                attributeEngine.addAttribute(this.mutableFormatSource, motcleExport);
            }
        }

        private void addThesaurusMetadata(ThesaurusMetadataExport thesaurusMetadataExport, ThesaurusMetadata thesaurusMetadata) {
            this.addIntitule(thesaurusMetadataExport, thesaurusMetadata, null, 1);
            if (this.exportInclude.isWithAttributeFilter()) {
                Predicate<AttributeKey> attributeFilter = this.exportInclude.getAttributeFilter();
                for (Attribute attribute : thesaurusMetadata.getAttributes()) {
                    AttributeKey attributeKey = attribute.getAttributeKey();
                    if (!attributeFilter.test(attributeKey)) continue;
                    for (String value : attribute) {
                        thesaurusMetadataExport.addAttributeValue(attributeKey.getNameSpace(), attributeKey.getLocalKey(), value);
                    }
                }
            }
            ScrutariExportEngine.this.hookHandler.handle("ThesaurusMetadata", thesaurusMetadataExport, thesaurusMetadata, this.exportInclude.getHookList());
        }

        private void addIntitule(ThesaurusMetadataExport thesaurusMetadataExport, ThesaurusMetadata thesaurusMetadata, @Nullable String name, int intituleType) {
            Labels labels = name == null ? thesaurusMetadata.getTitleLabels() : thesaurusMetadata.getPhrases().getPhrase(name);
            if (labels != null) {
                Label label;
                boolean done = false;
                for (Lang lang : ScrutariExportEngine.this.langArray) {
                    Label label2 = labels.getLabel(lang);
                    if (label2 == null) continue;
                    thesaurusMetadataExport.setIntitule(intituleType, label2.getLang().toString(), label2.getLabelString());
                    done = true;
                }
                if (!done && (label = labels.getFirstLabel()) != null) {
                    thesaurusMetadataExport.setIntitule(intituleType, label.getLang().toString(), label.getLabelString());
                }
            }
        }
    }

    private class CorpusEngine {
        private final Corpus corpus;
        private final Collection<SubsetItem> subsetItems;
        private final ComplementEngine[] complementEngineArray;
        private final AttributeEngine[] attributeEngineArray;
        private final ExportInclude exportInclude;
        private FieldKey geolocalisationFieldKey;
        private final SourceFormatter titreFormatter;
        private final SourceFormatter soustitreFormatter;
        private final SourceFormatter dateFormatter;
        private final SourceFormatter hrefFormatter;
        private final SourceFormatter ficheIconFormatter;
        private String multilangMode = null;
        private Set<Lang> multilangSet = null;
        private FieldKey multilangFieldKey = null;

        private CorpusEngine(Corpus corpus, CorpusScrutariDef corpusScrutariDef, SourceFormatter titreFormatter, SourceFormatter soustitreFormatter, SourceFormatter dateFormatter, SourceFormatter hrefFormatter, SourceFormatter ficheIconFormatter, ComplementEngine[] complementEngineArray, AttributeEngine[] attributeEngineArray) {
            this.corpus = corpus;
            CorpusField geolocalisationField = corpus.getCorpusMetadata().getGeolocalisationField();
            if (geolocalisationField != null) {
                this.geolocalisationFieldKey = geolocalisationField.getFieldKey();
            }
            this.subsetItems = FichothequeUtils.filterAndSort(corpus, ScrutariExportEngine.this.predicate);
            this.titreFormatter = titreFormatter;
            this.soustitreFormatter = soustitreFormatter;
            this.dateFormatter = dateFormatter;
            this.hrefFormatter = hrefFormatter;
            this.ficheIconFormatter = ficheIconFormatter;
            this.complementEngineArray = complementEngineArray;
            this.attributeEngineArray = attributeEngineArray;
            this.multilangMode = corpusScrutariDef.getMultilangMode();
            if (this.multilangMode != null) {
                String multilangParam = corpusScrutariDef.getMultilangParam();
                boolean done = false;
                switch (this.multilangMode) {
                    case "langui": {
                        done = this.initLanguiMultilangMode();
                        break;
                    }
                    case "thesaurus": {
                        done = this.initThesaurusMultilangMode(multilangParam);
                        break;
                    }
                    case "field": {
                        done = this.initFieldMultilangMode(multilangParam);
                        break;
                    }
                    case "custom": {
                        done = this.initCustomMultilangMode(multilangParam);
                    }
                }
                if (!done) {
                    this.multilangMode = null;
                }
            }
            this.exportInclude = ExportInclude.parse(corpusScrutariDef.getIncludeTokenList());
        }

        private boolean initLanguiMultilangMode() {
            Langs uiLangs = ScrutariExportEngine.this.scrutariExportDef.getUiLangs();
            if (uiLangs.isEmpty()) {
                return false;
            }
            this.multilangSet = new LinkedHashSet<Lang>(uiLangs);
            return true;
        }

        private boolean initThesaurusMultilangMode(String multiLangParam) {
            try {
                SubsetKey subsetKey = SubsetKey.parse((short)2, multiLangParam);
                Thesaurus thesaurus = (Thesaurus)ScrutariExportEngine.this.fichotheque.getSubset(subsetKey);
                if (thesaurus != null && !thesaurus.isBabelienType()) {
                    LinkedHashSet<Lang> result = new LinkedHashSet<Lang>();
                    Langs langs = ScrutariExportEngine.this.thesaurusLangChecker.getAuthorizedLangs(thesaurus);
                    for (Lang lang : langs) {
                        result.add(lang);
                    }
                    this.multilangSet = result;
                    return true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return false;
        }

        private boolean initFieldMultilangMode(String multiLangParam) {
            try {
                FieldKey fieldKey;
                this.multilangFieldKey = fieldKey = FieldKey.parse(multiLangParam);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        private boolean initCustomMultilangMode(String multiLangParam) {
            Lang[] customLangArray = LangsUtils.toCleanLangArray(multiLangParam);
            if (customLangArray.length == 0) {
                customLangArray = ScrutariExportEngine.this.langArray;
            }
            LinkedHashSet<Lang> result = new LinkedHashSet<Lang>();
            int length = customLangArray.length;
            for (int i = 0; i < length; ++i) {
                result.add(customLangArray[i]);
            }
            this.multilangSet = result;
            return true;
        }

        private void run() {
            CorpusMetadataExport corpusMetadataExport = ScrutariExportEngine.this.scrutariDataExport.newCorpus(this.corpus.getSubsetName());
            this.addCorpusMetadata(corpusMetadataExport, this.corpus.getCorpusMetadata());
            FichePointeur fichePointeur = PointeurFactory.newFichePointeur(this.corpus);
            for (SubsetItem subsetItem : this.subsetItems) {
                fichePointeur.setCurrentSubsetItem(subsetItem);
                if (this.multilangMode != null) {
                    this.addMultilangFiche(fichePointeur);
                    continue;
                }
                this.addFiche(fichePointeur);
            }
        }

        private void addCorpusMetadata(CorpusMetadataExport corpusMetadataExport, CorpusMetadata corpusMetadata) {
            this.addIntitule(corpusMetadataExport, corpusMetadata, null, 1);
            this.addIntitule(corpusMetadataExport, corpusMetadata, "fiche", 2);
            for (ComplementEngine complementEngine : this.complementEngineArray) {
                complementEngine.addIntitule(corpusMetadataExport);
            }
            if (this.exportInclude.isWithAttributeFilter()) {
                Predicate<AttributeKey> attributeFilter = this.exportInclude.getAttributeFilter();
                for (Attribute attribute : corpusMetadata.getAttributes()) {
                    AttributeKey attributeKey = attribute.getAttributeKey();
                    if (!attributeFilter.test(attributeKey)) continue;
                    for (String value : attribute) {
                        corpusMetadataExport.addAttributeValue(attributeKey.getNameSpace(), attributeKey.getLocalKey(), value);
                    }
                }
            }
            ScrutariExportEngine.this.hookHandler.handle("CorpusMetadata", corpusMetadataExport, corpusMetadata, this.exportInclude.getHookList());
        }

        private void addIntitule(CorpusMetadataExport corpusMetadataExport, CorpusMetadata corpusMetadata, String name, int intituleType) {
            Labels labels = name == null ? corpusMetadata.getTitleLabels() : corpusMetadata.getPhrases().getPhrase(name);
            if (labels != null) {
                Label label;
                boolean done = false;
                for (Lang lang : ScrutariExportEngine.this.langArray) {
                    Label label2 = labels.getLabel(lang);
                    if (label2 == null) continue;
                    corpusMetadataExport.setIntitule(intituleType, label2.getLang().toString(), label2.getLabelString());
                    done = true;
                }
                if (!done && (label = labels.getFirstLabel()) != null) {
                    corpusMetadataExport.setIntitule(intituleType, label.getLang().toString(), label.getLabelString());
                }
            }
        }

        private void addMultilangFiche(FichePointeur fichePointeur) {
            FicheMeta ficheMeta = (FicheMeta)fichePointeur.getCurrentSubsetItem();
            Set<Lang> langSet = this.getLangSet(fichePointeur);
            int size = langSet.size();
            if (size == 0) {
                return;
            }
            int ficheid = ficheMeta.getId();
            String ficheidString = String.valueOf(ficheid);
            GeopointItem geopoint = this.getGeoloc(fichePointeur);
            String[] idStringArray = new String[size];
            int p = 0;
            for (Lang lang : langSet) {
                String id;
                ExtractionContext customExtractionContext = ExtractionUtils.derive(ScrutariExportEngine.this.extractionContext, LocalisationUtils.toUserLangContext(lang));
                FormatSource formatSource = FormatterUtils.toFormatSource(fichePointeur, customExtractionContext, ScrutariExportEngine.this.predicate, ScrutariExportEngine.this.formatContext);
                String titre = this.titreFormatter.formatSource(formatSource);
                titre = titre == null ? "" : titre.trim();
                if (titre.length() == 0) {
                    idStringArray[p] = null;
                    ++p;
                    continue;
                }
                String langString = lang.toString();
                idStringArray[p] = id = ficheidString + "_" + langString;
                ++p;
                FicheExport ficheExport = ScrutariExportEngine.this.scrutariDataExport.newFiche(id);
                ficheExport.setTitre(titre);
                ficheExport.setSoustitre(this.soustitreFormatter.formatSource(formatSource));
                ficheExport.setLang(langString);
                ficheExport.setDate(this.dateFormatter.formatSource(formatSource));
                ficheExport.setHref(this.hrefFormatter.formatSource(formatSource));
                ficheExport.setFicheIcon(this.ficheIconFormatter.formatSource(formatSource));
                int complementLength = this.complementEngineArray.length;
                for (int i = 0; i < complementLength; ++i) {
                    this.complementEngineArray[i].addComplement(i + 1, formatSource, ficheExport);
                }
                for (AttributeEngine attributeEngine : this.attributeEngineArray) {
                    attributeEngine.addAttribute(formatSource, ficheExport);
                }
                if (geopoint != null) {
                    ficheExport.setGeoloc(geopoint.getLatitude().toString(), geopoint.getLongitude().toString());
                }
                if (langSet.size() <= 1) continue;
                for (Lang otherLang : langSet) {
                    if (otherLang.equals(lang)) continue;
                    ficheExport.addAttributeValue("rel", "alternate", ficheidString + "_" + otherLang.toString());
                }
            }
            if (ScrutariExportEngine.this.thesaurusEngineArray != null) {
                String corpusName = this.corpus.getSubsetName();
                for (ThesaurusEngine thesaurusEngine : ScrutariExportEngine.this.thesaurusEngineArray) {
                    Thesaurus thesaurus = thesaurusEngine.getThesaurus();
                    String thesaurusName = thesaurus.getSubsetName();
                    for (Liaison liaison : fichePointeur.getStandardLiaisons(thesaurus)) {
                        int weight = liaison.getTie().getWeight();
                        int motcleid = liaison.getSubsetItem().getId();
                        thesaurusEngine.addId(motcleid);
                        String idString = String.valueOf(motcleid);
                        for (String ficheId : idStringArray) {
                            if (ficheId == null) continue;
                            ScrutariExportEngine.this.scrutariDataExport.addIndexation(corpusName, ficheId, thesaurusName, idString, weight);
                        }
                    }
                }
            }
        }

        private Set<Lang> getLangSet(FichePointeur fichePointeur) {
            if (this.multilangSet != null) {
                return this.multilangSet;
            }
            LinkedHashSet<Lang> result = new LinkedHashSet<Lang>();
            Object value = fichePointeur.getValue(this.multilangFieldKey);
            if (value instanceof LanguageItem) {
                result.add(((LanguageItem)value).getLang());
            } else if (value instanceof FicheItems) {
                for (FicheItem ficheItem : (FicheItems)value) {
                    if (!(ficheItem instanceof LanguageItem)) continue;
                    result.add(((LanguageItem)ficheItem).getLang());
                }
            }
            return result;
        }

        private void addFiche(FichePointeur fichePointeur) {
            FicheMeta ficheMeta = (FicheMeta)fichePointeur.getCurrentSubsetItem();
            Lang ficheLang = ficheMeta.getLang();
            UserLangContext langContext = ficheLang != null ? LocalisationUtils.toUserLangContext(ficheLang) : LocalisationUtils.toUserLangContext(ScrutariExportEngine.this.langArray[0]);
            ExtractionContext customExtractionContext = ExtractionUtils.derive(ScrutariExportEngine.this.extractionContext, langContext);
            FormatSource formatSource = FormatterUtils.toFormatSource(fichePointeur, customExtractionContext, ScrutariExportEngine.this.predicate, ScrutariExportEngine.this.formatContext);
            int ficheid = ficheMeta.getId();
            String idString = String.valueOf(ficheid);
            FicheExport ficheExport = ScrutariExportEngine.this.scrutariDataExport.newFiche(idString);
            ficheExport.setTitre(this.titreFormatter.formatSource(formatSource));
            ficheExport.setSoustitre(this.soustitreFormatter.formatSource(formatSource));
            if (ficheLang != null) {
                ficheExport.setLang(ficheLang.toString());
            }
            ficheExport.setDate(this.dateFormatter.formatSource(formatSource));
            ficheExport.setHref(this.hrefFormatter.formatSource(formatSource));
            ficheExport.setFicheIcon(this.ficheIconFormatter.formatSource(formatSource));
            int complementLength = this.complementEngineArray.length;
            for (int i = 0; i < complementLength; ++i) {
                this.complementEngineArray[i].addComplement(i + 1, formatSource, ficheExport);
            }
            for (AttributeEngine attributeEngine : this.attributeEngineArray) {
                attributeEngine.addAttribute(formatSource, ficheExport);
            }
            GeopointItem geopoint = this.getGeoloc(fichePointeur);
            if (geopoint != null) {
                ficheExport.setGeoloc(geopoint.getLatitude().toString(), geopoint.getLongitude().toString());
            }
            if (ScrutariExportEngine.this.thesaurusEngineArray != null) {
                String corpusName = this.corpus.getSubsetName();
                for (ThesaurusEngine thesaurusEngine : ScrutariExportEngine.this.thesaurusEngineArray) {
                    Thesaurus thesaurus = thesaurusEngine.getThesaurus();
                    String thesaurusName = thesaurus.getSubsetName();
                    for (Liaison liaison : fichePointeur.getStandardLiaisons(thesaurus)) {
                        int weight = liaison.getTie().getWeight();
                        int motcleid = liaison.getSubsetItem().getId();
                        thesaurusEngine.addId(motcleid);
                        ScrutariExportEngine.this.scrutariDataExport.addIndexation(corpusName, idString, thesaurusName, String.valueOf(motcleid), weight);
                    }
                }
            }
        }

        private GeopointItem getGeoloc(FichePointeur fichePointeur) {
            FicheItem ficheItem;
            if (this.geolocalisationFieldKey != null && (ficheItem = (FicheItem)fichePointeur.getValue(this.geolocalisationFieldKey)) != null && ficheItem instanceof GeopointItem) {
                return (GeopointItem)ficheItem;
            }
            return null;
        }
    }

    private static class ComplementEngine {
        private Labels labels;
        private final SourceFormatter formatter;
        private boolean isCustomLabels = false;
        private Lang[] langArray;

        private ComplementEngine(SourceFormatter formatter) {
            this.formatter = formatter;
        }

        private void setCustomLabels(Labels customLabels) {
            this.labels = customLabels;
            this.isCustomLabels = true;
        }

        private void setDefaultLabels(Labels labels, Lang[] langArray) {
            this.labels = labels;
            this.isCustomLabels = false;
            this.langArray = langArray;
        }

        private void addIntitule(CorpusMetadataExport corpusMetadataExport) {
            Label label;
            if (this.labels == null) {
                return;
            }
            int number = corpusMetadataExport.addComplement();
            boolean done = false;
            if (this.isCustomLabels) {
                for (Label label2 : this.labels) {
                    corpusMetadataExport.setComplementIntitule(number, label2.getLang().toString(), label2.getLabelString());
                    done = true;
                }
            } else {
                for (Lang lang : this.langArray) {
                    Label label3 = this.labels.getLabel(lang);
                    if (label3 == null) continue;
                    corpusMetadataExport.setComplementIntitule(number, lang.toString(), label3.getLabelString());
                    done = true;
                }
            }
            if (!done && (label = this.labels.getFirstLabel()) != null) {
                corpusMetadataExport.setComplementIntitule(number, label.getLang().toString(), label.getLabelString());
            }
        }

        private void addComplement(int complementNumber, FormatSource formatSource, FicheExport ficheExport) {
            String s = this.formatter.formatSource(formatSource);
            ficheExport.addComplement(complementNumber, s);
        }
    }

    private static class AttributeEngine {
        private final String nameSpace;
        private final String localKey;
        private final SourceFormatter formatter;

        private AttributeEngine(AttributeKey attributeKey, SourceFormatter formatter) {
            this.formatter = formatter;
            this.nameSpace = attributeKey.getNameSpace();
            this.localKey = attributeKey.getLocalKey();
        }

        private void addAttribute(FormatSource formatSource, FicheExport ficheExport) {
            for (String token : this.getTokens(formatSource)) {
                ficheExport.addAttributeValue(this.nameSpace, this.localKey, token);
            }
        }

        private void addAttribute(FormatSource formatSource, MotcleExport motcleExport) {
            for (String token : this.getTokens(formatSource)) {
                motcleExport.addAttributeValue(this.nameSpace, this.localKey, token);
            }
        }

        private String[] getTokens(FormatSource formatSource) {
            String s = this.formatter.formatSource(formatSource);
            return StringUtils.getTokens(s, '\n', (short)2);
        }
    }

    private static class HrefSourceFormatter
    implements SourceFormatter {
        private final AccoladePattern hrefPattern;
        private final FicheValueResolver ficheValueResolver = new FicheValueResolver();

        public HrefSourceFormatter(AccoladePattern hrefPattern) {
            this.hrefPattern = hrefPattern;
        }

        @Override
        public String formatSource(FormatSource formatSource) {
            this.ficheValueResolver.setCurrentFicheMeta((FicheMeta)formatSource.getSubsetItemPointeur().getCurrentSubsetItem());
            this.ficheValueResolver.setCurrentLang(formatSource.getDefaultLang());
            return this.hrefPattern.format(this.ficheValueResolver);
        }

        private static class FicheValueResolver
        implements ValueResolver {
            private FicheMeta ficheMeta;
            private Lang workingLang;

            private FicheValueResolver() {
            }

            private void setCurrentFicheMeta(FicheMeta ficheMeta) {
                this.ficheMeta = ficheMeta;
            }

            private void setCurrentLang(Lang workingLang) {
                this.workingLang = workingLang;
            }

            @Override
            public String getValue(AccoladeArgument accoladeArgument) {
                switch (accoladeArgument.getName()) {
                    case "corpus": {
                        return this.ficheMeta.getSubsetName();
                    }
                    case "id": 
                    case "idcorpus": {
                        return String.valueOf(this.ficheMeta.getId());
                    }
                    case "lang": {
                        return this.workingLang.toString();
                    }
                    case "idalpha": {
                        return this.getMasterIdalpha();
                    }
                }
                return null;
            }

            private String getMasterIdalpha() {
                Subset master = this.ficheMeta.getCorpus().getMasterSubset();
                if (master != null && master instanceof Thesaurus) {
                    return ((Motcle)master.getSubsetItemById(this.ficheMeta.getId())).getIdalpha();
                }
                return null;
            }
        }
    }

    private static class MutableFormatSource
    implements FormatSource {
        private final SubsetItemPointeur subsetItemPointeur;
        private final FormatContext formatContext;
        private final Predicate<SubsetItem> predicate;
        private final ExtractionContext orignalExtractionContext;
        private ExtractionContext customExtractionContext;
        private LangContext langContext;

        private MutableFormatSource(SubsetItemPointeur subsetItemPointeur, ExtractionContext orignalExtractionContext, FormatContext formatContext, Predicate<SubsetItem> predicate) {
            this.subsetItemPointeur = subsetItemPointeur;
            this.orignalExtractionContext = orignalExtractionContext;
            this.formatContext = formatContext;
            this.predicate = predicate;
        }

        @Override
        public SubsetItemPointeur getSubsetItemPointeur() {
            return this.subsetItemPointeur;
        }

        @Override
        public ExtractionContext getExtractionContext() {
            return this.customExtractionContext;
        }

        private void setLangContext(LangContext langContext) {
            this.customExtractionContext = ExtractionUtils.derive(this.orignalExtractionContext, langContext);
        }

        @Override
        public Predicate<SubsetItem> getGlobalPredicate() {
            return this.predicate;
        }

        @Override
        public FormatContext getFormatContext() {
            return this.formatContext;
        }

        @Override
        public CellConverterProvider getCellConverterProvider() {
            return TableExportUtils.EMPTY_CELLCONVERTERPROVIDER;
        }

        @Override
        public FormatSource.History getHistory() {
            return FormatterUtils.EMPTY_FORMATSOURCEHISTORY;
        }

        @Override
        public FormatSource.ExtractionInfo getExtractionInfo() {
            return null;
        }
    }
}

