/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.selection;

import java.util.List;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.date.FuzzyDate;

public interface PeriodCondition {
    public static final String DATE_TYPE = "date";
    public static final String ANY_TYPE = "any";
    public static final String SAME_TYPE = "same";
    public static final String ANY_CHAR = "*";

    public String getStartType();

    public FuzzyDate getStartDate();

    public String getEndType();

    public FuzzyDate getEndDate();

    public boolean isOnCreationDate();

    public boolean isOnModificationDate();

    public List<FieldKey> getFieldKeyList();

    default public String getStartString() {
        switch (this.getStartType()) {
            case "any": {
                return ANY_CHAR;
            }
            case "date": {
                return this.getStartDate().toString();
            }
        }
        throw new IllegalStateException("getStartType() is wrong: " + this.getStartType());
    }

    default public String getEndString() {
        switch (this.getEndType()) {
            case "any": {
                return ANY_CHAR;
            }
            case "date": {
                return this.getEndDate().toString();
            }
            case "same": {
                return SAME_TYPE;
            }
        }
        throw new IllegalStateException("getEndType() is wrong: " + this.getEndType());
    }
}

