/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.exportation.transformation;

import java.text.ParseException;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValidExtension;

public final class TemplateKey
implements Comparable<TemplateKey> {
    public static final String DEFAULT_NAME = "_default";
    public static final String FRAGMENT_NAME = "_fragment";
    public static final String CLEAN_NAME = "_clean";
    private final String key;
    private final TransformationKey transformationKey;
    private final ValidExtension extension;
    private final String name;
    private final boolean isDist;

    private TemplateKey(TransformationKey transformationKey) {
        this(transformationKey, null, DEFAULT_NAME);
    }

    private TemplateKey(TransformationKey transformationKey, ValidExtension extension) {
        this(transformationKey, extension, DEFAULT_NAME);
    }

    private TemplateKey(TransformationKey transformationKey, ValidExtension extension, String name) {
        this.transformationKey = transformationKey;
        this.extension = extension;
        this.name = name;
        this.isDist = TemplateKey.isDist(name);
        this.key = extension == null ? transformationKey + "/" + name : transformationKey + "/" + name + "." + extension;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.key.equals(((TemplateKey)other).key);
    }

    public String getKeyString() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public int compareTo(TemplateKey otherTemplateKey) {
        return this.key.compareTo(otherTemplateKey.key);
    }

    public boolean isDist() {
        return this.isDist;
    }

    public boolean isSimpleTemplate() {
        return this.extension == null;
    }

    public boolean isStreamTemplate() {
        return this.extension != null;
    }

    public TransformationKey getTransformationKey() {
        return this.transformationKey;
    }

    @Nullable
    public String getExtension() {
        if (this.extension != null) {
            return this.extension.toString();
        }
        return null;
    }

    public ValidExtension getValidExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteName() {
        if (this.extension != null) {
            return this.getName() + "." + this.extension.toString();
        }
        return this.getName();
    }

    public static TemplateKey parse(TransformationKey transformationKey, String name) throws ParseException {
        if (transformationKey == null) {
            throw new IllegalArgumentException("transformationKey is null");
        }
        return TemplateKey.parse(transformationKey, null, name);
    }

    public static TemplateKey parse(TransformationKey transformationKey, ValidExtension extension, String name) throws ParseException {
        if (transformationKey == null) {
            throw new IllegalArgumentException("transformationKey is null");
        }
        name = TemplateKey.checkTemplateName(name, extension);
        return new TemplateKey(transformationKey, extension, name);
    }

    public static TemplateKey parse(String keyString) throws ParseException {
        int idx = keyString.indexOf(47);
        if (idx == -1) {
            throw new ParseException("separator / is missing", 0);
        }
        TransformationKey transformationKey = TransformationKey.parse(keyString.substring(0, idx));
        String name = keyString.substring(idx + 1);
        if (name.length() == 0) {
            return new TemplateKey(transformationKey);
        }
        int pointIdx = name.indexOf(46);
        switch (pointIdx) {
            case -1: {
                return TemplateKey.parse(transformationKey, null, name);
            }
            case 0: {
                ValidExtension validExtension = ValidExtension.parse(name.substring(1));
                return new TemplateKey(transformationKey, validExtension);
            }
        }
        ValidExtension validExtension = ValidExtension.parse(name.substring(pointIdx + 1));
        return TemplateKey.parse(transformationKey, validExtension, name.substring(0, pointIdx));
    }

    public static TemplateKey toDefault(TransformationKey transformationKey) {
        return new TemplateKey(transformationKey);
    }

    public static TemplateKey toDefault(TransformationKey transformationKey, ValidExtension extension) {
        if (extension == null) {
            return new TemplateKey(transformationKey);
        }
        return new TemplateKey(transformationKey, extension);
    }

    private static String checkTemplateName(String name, ValidExtension extension) throws ParseException {
        if (name == null || name.isEmpty()) {
            return DEFAULT_NAME;
        }
        switch (name) {
            case "_default": {
                return DEFAULT_NAME;
            }
            case "_fragment": {
                if (extension == null) {
                    return FRAGMENT_NAME;
                }
                throw new ParseException("_fragment is not available for extension template", 0);
            }
            case "_clean": {
                if (extension == null) {
                    return CLEAN_NAME;
                }
                throw new ParseException("_fragment is not available for extension template", 0);
            }
        }
        StringUtils.checkTechnicalName(name, true);
        return name;
    }

    private static boolean isDist(String name) {
        return name.startsWith("_");
    }
}

