/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.album;

public interface AlbumConstants {
    public static final String JPG_FORMATTYPE = "jpg";
    public static final String PNG_FORMATTYPE = "png";
    public static final String FIXEDWIDTH_DIMTYPE = "fixed-width";
    public static final String FIXEDHEIGHT_DIMTYPE = "fixed-height";
    public static final String MAXWIDTH_DIMTYPE = "max-width";
    public static final String MAXHEIGHT_DIMTYPE = "max-height";
    public static final String MAXDIM_DIMTYPE = "max-dim";
    public static final String MINI_SPECIALDIM = "_mini";
    public static final String ORIGINAL_SPECIALDIM = "_original";
    public static final String VIGNETTE_USAGE = "vignette";
    public static final String DETAIL_USAGE = "detail";

    public static String checkDimType(String dimType) {
        switch (dimType) {
            case "fixed-width": {
                return FIXEDWIDTH_DIMTYPE;
            }
            case "fixed-height": {
                return FIXEDHEIGHT_DIMTYPE;
            }
            case "max-width": {
                return MAXWIDTH_DIMTYPE;
            }
            case "max-height": {
                return MAXHEIGHT_DIMTYPE;
            }
            case "max-dim": {
                return MAXDIM_DIMTYPE;
            }
        }
        throw new IllegalArgumentException("unknown type " + dimType);
    }

    public static String checkFormatType(String formatType) {
        switch (formatType = formatType.toLowerCase()) {
            case "png": {
                return PNG_FORMATTYPE;
            }
            case "jpg": 
            case "jpeg": {
                return JPG_FORMATTYPE;
            }
        }
        throw new IllegalArgumentException("unknown type " + formatType);
    }

    public static String checkSpecialDim(String specialDim) {
        switch (specialDim) {
            case "_original": {
                return ORIGINAL_SPECIALDIM;
            }
            case "_mini": {
                return MINI_SPECIALDIM;
            }
        }
        throw new IllegalArgumentException("Unknown specialDim : " + specialDim);
    }

    public static boolean needWidth(String dimType) {
        switch (dimType) {
            case "fixed-width": 
            case "max-width": 
            case "max-dim": {
                return true;
            }
        }
        return false;
    }

    public static boolean needHeight(String dimType) {
        switch (dimType) {
            case "fixed-height": 
            case "max-height": 
            case "max-dim": {
                return true;
            }
        }
        return false;
    }
}

