/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui;

import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponentFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UiComponentFilterBuilder {
    private final Set<String> excludeSet = new HashSet<String>();
    private final Map<String, UiComponent> replaceMap = new HashMap<String, UiComponent>();

    public void excludeUiComponent(UiComponent uiComponent) {
        this.excludeSet.add(uiComponent.getName());
    }

    public void replaceUiComponent(UiComponent uiComponent) {
        this.replaceMap.put(uiComponent.getName(), uiComponent);
    }

    public UiComponentFilter toComponentUiFilter() {
        return new InternalUiComponentFilter(this.excludeSet, this.replaceMap);
    }

    private static class InternalUiComponentFilter
    implements UiComponentFilter {
        private final Set<String> excludeSet;
        private final Map<String, UiComponent> replaceMap;

        private InternalUiComponentFilter(Set<String> excludeSet, Map<String, UiComponent> replaceMap) {
            this.excludeSet = excludeSet;
            this.replaceMap = replaceMap;
        }

        @Override
        public UiComponent filter(UiComponent uiComponent) {
            String keyString = uiComponent.getName();
            if (this.excludeSet.contains(keyString)) {
                return null;
            }
            UiComponent other = this.replaceMap.get(keyString);
            if (other != null) {
                return other;
            }
            return uiComponent;
        }
    }
}

