/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui;

import fr.exemole.bdfserver.api.ui.MetadataPhraseDef;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.localisation.Litteral;

public class MetadataPhraseDefBuilder {
    private final String name;
    private Object l10nObject;
    private int size = 30;

    public MetadataPhraseDefBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null ");
        }
        if (!FichothequeUtils.isValidPhraseName(name)) {
            throw new IllegalArgumentException("name is invalid");
        }
        this.name = name;
    }

    public MetadataPhraseDefBuilder setL10nObject(Object l10nObject) {
        this.l10nObject = l10nObject;
        return this;
    }

    public MetadataPhraseDefBuilder setSize(int size) {
        if (size < 1) {
            size = 30;
        }
        this.size = size;
        return this;
    }

    public MetadataPhraseDef toMetadataPhraseDef() {
        Object finalL10nObject = this.l10nObject != null ? this.l10nObject : new Litteral("[" + this.name + "]");
        return new InternalMetadataPhraseDef(this.name, finalL10nObject, this.size);
    }

    public static MetadataPhraseDefBuilder init(String name) {
        return new MetadataPhraseDefBuilder(name);
    }

    private static class InternalMetadataPhraseDef
    implements MetadataPhraseDef {
        private final String name;
        private final Object l10nObject;
        private final int size;

        private InternalMetadataPhraseDef(String name, Object l10nObject, int size) {
            this.name = name;
            this.l10nObject = l10nObject;
            this.size = size;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getL10nObject() {
            return this.l10nObject;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }
}

