/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.providers;

import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import java.util.ArrayList;
import java.util.List;

public class MultiBdfCommandProviderBuilder {
    private final List<BdfCommandProvider> providerList = new ArrayList<BdfCommandProvider>();

    public MultiBdfCommandProviderBuilder addBdfCommandProvider(BdfCommandProvider bdfCommandProvider) {
        if (bdfCommandProvider instanceof MultiBdfCommandProvider) {
            BdfCommandProvider[] array;
            for (BdfCommandProvider provider : array = ((MultiBdfCommandProvider)bdfCommandProvider).array) {
                this.providerList.add(provider);
            }
        } else {
            this.providerList.add(bdfCommandProvider);
        }
        return this;
    }

    public BdfCommandProvider toBdfCommandProvider() {
        return new MultiBdfCommandProvider(this.providerList.toArray(new BdfCommandProvider[this.providerList.size()]));
    }

    public static MultiBdfCommandProviderBuilder init() {
        return new MultiBdfCommandProviderBuilder();
    }

    private static class MultiBdfCommandProvider
    implements BdfCommandProvider {
        private final BdfCommandProvider[] array;

        private MultiBdfCommandProvider(BdfCommandProvider[] array) {
            this.array = array;
        }

        @Override
        public BdfCommand getBdfCommand(BdfCommandParameters parameters) {
            for (BdfCommandProvider provider : this.array) {
                BdfCommand bdfCommand = provider.getBdfCommand(parameters);
                if (bdfCommand == null) continue;
                return bdfCommand;
            }
            return null;
        }
    }
}

