/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Document;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;

public class PermissionChecker {
    private final PermissionSummary permissionSummary;

    public PermissionChecker(BdfParameters bdfParameters) {
        this.permissionSummary = bdfParameters.getPermissionSummary();
    }

    public PermissionChecker checkAdmin(String ... actionNames) throws PermissionException {
        if (actionNames != null) {
            for (String actionName : actionNames) {
                PermissionCheck.checkAdmin(this.permissionSummary, actionName);
            }
        }
        return this;
    }

    public PermissionChecker checkHistory(Subset subset, int id) throws PermissionException {
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem != null && subsetItem instanceof FicheMeta) {
            this.checkRead((FicheMeta)subsetItem);
        } else {
            this.checkSubsetAdmin(subset);
        }
        return this;
    }

    public PermissionChecker checkSubsetAdmin(Subset subset) throws PermissionException {
        PermissionCheck.checkSubsetAdmin(this.permissionSummary, subset);
        return this;
    }

    public PermissionChecker checkSubsetAccess(Subset subset) throws PermissionException {
        PermissionCheck.checkSubsetAccess(this.permissionSummary, subset);
        return this;
    }

    public PermissionChecker checkWrite(Illustration illustration) throws PermissionException {
        PermissionCheck.checkWrite(this.permissionSummary, illustration);
        return this;
    }

    public PermissionChecker checkWrite(Document document) throws PermissionException {
        PermissionCheck.checkWrite(this.permissionSummary, document);
        return this;
    }

    public PermissionChecker checkWrite(FicheMeta ficheMeta) throws PermissionException {
        PermissionCheck.checkWrite(this.permissionSummary, ficheMeta);
        return this;
    }

    public PermissionChecker checkRead(FicheMeta ficheMeta) throws PermissionException {
        PermissionCheck.checkRead(this.permissionSummary, ficheMeta);
        return this;
    }

    public PermissionChecker checkFicheCreate(Corpus corpus) throws PermissionException {
        PermissionCheck.checkFicheCreate(this.permissionSummary, corpus);
        return this;
    }

    public static PermissionChecker init(BdfParameters bdfParameters) {
        return new PermissionChecker(bdfParameters);
    }
}

