/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.tools.exportation.transformation.compilers.InsertPart;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertyPart;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

class PropertiesOdParser {
    private final String content;
    private final List<Object> partList = new ArrayList<Object>();
    private int currentStart = 0;

    PropertiesOdParser(String content) {
        this.content = content;
    }

    private boolean next() {
        int inputTagStartIndex = this.content.indexOf("<text:text-input", this.currentStart);
        if (inputTagStartIndex == -1) {
            this.partList.add(this.content.substring(this.currentStart));
            return false;
        }
        String precedingText = this.content.substring(this.currentStart, inputTagStartIndex);
        int inputContentStartIndex = this.content.indexOf(">", inputTagStartIndex) + 1;
        if (this.content.charAt(inputContentStartIndex - 2) == '/') {
            this.add(precedingText);
            this.currentStart = inputContentStartIndex;
            return true;
        }
        int inputContentEndIndex = this.content.indexOf("</text:text-input>", inputContentStartIndex);
        int newStart = inputContentEndIndex + "</text:text-input>".length();
        PropertyPart propertyPart = PropertyPart.parse(this.content.substring(inputContentStartIndex, inputContentEndIndex));
        if (PropertiesOdParser.replaceParagraph(propertyPart)) {
            int[] newIndices = this.getNewIndices(precedingText, inputContentEndIndex);
            if (newIndices != null) {
                precedingText = precedingText.substring(0, newIndices[0]);
                newStart = newIndices[1];
            } else {
                precedingText = precedingText + " #ERROR(" + propertyPart.getName() + ")#";
                propertyPart = null;
            }
        }
        this.add(precedingText);
        this.add(propertyPart);
        this.currentStart = newStart;
        return true;
    }

    private void add(String rawText) {
        if (!rawText.isEmpty()) {
            int index = rawText.indexOf("</office:automatic-styles>");
            if (index != -1) {
                this.partList.add(rawText.substring(0, index));
                this.partList.add(new InsertPart("automatic-styles"));
                this.partList.add(rawText.substring(index));
            } else {
                this.partList.add(rawText);
            }
        }
    }

    private void add(PropertyPart propertyPart) {
        if (propertyPart != null) {
            this.partList.add(propertyPart);
        }
    }

    private int[] getNewIndices(String precedingText, int followingIndex) {
        int lastParagraphIndex = precedingText.lastIndexOf("<text:p");
        if (lastParagraphIndex == -1) {
            return null;
        }
        char nextChar = precedingText.charAt(lastParagraphIndex + "<text:p".length());
        if (nextChar != '>' && !Character.isWhitespace(nextChar)) {
            return null;
        }
        if (precedingText.indexOf("</text:p>", lastParagraphIndex) != -1) {
            return null;
        }
        int end = this.content.indexOf("</text:p>", followingIndex);
        if (end == -1) {
            return null;
        }
        int[] result = new int[]{lastParagraphIndex, end += "</text:p>".length()};
        return result;
    }

    static List<Object> parse(String content) throws ParseException {
        PropertiesOdParser parser = new PropertiesOdParser(content);
        while (parser.next()) {
        }
        return parser.partList;
    }

    private static boolean replaceParagraph(PropertyPart propertyPart) {
        switch (propertyPart.getMode()) {
            case "fragment": {
                return true;
            }
        }
        return false;
    }
}

