/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.sphere.metadata.SphereMetadataEditor;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;

public class FichothequeSphereCreateCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "FichothequeSphereCreate";

    public FichothequeSphereCreateCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        this.initCentralSphere();
        this.initBdfServer(false);
        BdfServer bdfServer = this.getBdfServer();
        synchronized (bdfServer) {
            try (EditSession editSession = this.newEditSession(COMMAND_NAME);){
                try {
                    SphereEditor sphereEditor = editSession.getFichothequeEditor().createSphere(this.centralSphere.getSphereKey());
                    SphereMetadataEditor sphereMetadataEditor = sphereEditor.getSphereMetadataEditor();
                    for (Label label : this.centralSphere.getMetadata().getTitleLabels()) {
                        sphereMetadataEditor.putTitle(label);
                    }
                }
                catch (ExistingSubsetException ese) {
                    throw BdfErrors.error("_ error.existing.sphere", this.centralSphere.getName());
                }
            }
        }
        return this.done("done.sphere.spherecreation", this.centralSphere.getName());
    }
}

