/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.thesaurus;

import fr.exemole.bdfserver.json.AccessJson;
import java.io.IOException;
import java.util.List;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;

public class ThesaurusJsonProperty
implements JsonProperty {
    private final Thesaurus thesaurus;
    private final Lang lang;
    private final CellConverter cellConverter;

    public ThesaurusJsonProperty(Thesaurus thesaurus, Lang lang, CellConverter cellConverter) {
        this.thesaurus = thesaurus;
        this.lang = lang;
        this.cellConverter = cellConverter;
    }

    @Override
    public String getName() {
        return "thesaurus";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.object();
        jw.key("name").value(this.thesaurus.getSubsetKey().getSubsetName());
        jw.key("array");
        this.writeMotcleList(jw, this.thesaurus.getFirstLevelList());
        jw.endObject();
    }

    private void writeMotcleList(JSONWriter jw, List<Motcle> motcleList) throws IOException {
        jw.array();
        for (Motcle motcle : motcleList) {
            jw.object();
            AccessJson.properties(jw, motcle, this.cellConverter, this.lang);
            jw.key("children");
            this.writeMotcleList(jw, motcle.getChildList());
            jw.endObject();
        }
        jw.endArray();
    }
}

