/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import fr.exemole.bdfserver.api.roles.SatelliteOpportunities;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;

public class SatelliteTree
implements Consumer<HtmlPrinter> {
    public static final HtmlWrapper TREE = Tree.tree("subset-satellite-Tree");
    public static final HtmlWrapper LEAF = Tree.leaf("subset-satellite-Leaf");
    private final Lang lang;
    private final Locale formatLocale;
    private String target = "Edition";
    private SubsetItem masterSubsetItem;
    private SatelliteOpportunities satelliteOpportunities;

    public SatelliteTree(Lang lang, Locale formatLocale) {
        this.lang = lang;
        this.formatLocale = formatLocale;
    }

    public SatelliteTree current(SubsetItem masterSubsetItem, SatelliteOpportunities satelliteOpportunities) {
        this.masterSubsetItem = masterSubsetItem;
        this.satelliteOpportunities = satelliteOpportunities;
        return this;
    }

    public SatelliteTree target(String target) {
        this.target = target;
        return this;
    }

    @Override
    public void accept(HtmlPrinter hp) {
        hp.__(TREE, () -> {
            for (SatelliteOpportunities.Entry entry : this.satelliteOpportunities.getEntryList()) {
                hp.__(LEAF, () -> {
                    short category = entry.getAvailableActionCategory();
                    switch (category) {
                        case 2: 
                        case 3: {
                            this.printSatelliteDisplay(hp, entry.getFicheMeta(), category == 2);
                            break;
                        }
                        case 1: {
                            this.printSatelliteCreation(hp, entry.getSatelliteCorpus(), String.valueOf(this.masterSubsetItem.getId()));
                            break;
                        }
                        default: {
                            throw new SwitchException("wrong type : " + category);
                        }
                    }
                });
            }
        });
    }

    public static SatelliteTree init(Lang lang, Locale formatLocale) {
        return new SatelliteTree(lang, formatLocale);
    }

    private boolean printSatelliteDisplay(HtmlPrinter hp, FicheMeta satelliteFiche, boolean canWrite) {
        String ficheTitle = CorpusMetadataUtils.getFicheTitle(satelliteFiche, this.lang, this.formatLocale);
        hp.SPAN("subset-satellite-CorpusTitle subset-satellite-Display").__escape(CorpusMetadataUtils.getSatelliteLabel(satelliteFiche.getCorpus(), this.lang)).__colon()._SPAN().A(HA.href(BdfInstructionUtils.getFicheGetLink(satelliteFiche, "html")).classes("global-button-Transparent action-FicheDisplay").target(this.target).title(hp.getLocalization("_ link.fiches.fiche_long") + " = " + ficheTitle)).__(Button.ICON)._A();
        if (canWrite) {
            hp.A(HA.href(BH.domain("edition").page("fiche-change").subsetItem(satelliteFiche)).target(this.target).classes("global-button-Transparent action-FicheEdit").title(hp.getLocalization("_ link.edition.fichechange_long") + " = " + ficheTitle)).__(Button.ICON)._A();
        }
        return true;
    }

    private boolean printSatelliteCreation(HtmlPrinter hp, Corpus satelliteCorpus, String idValue) {
        hp.SPAN("subset-satellite-CorpusTitle subset-satellite-Creation").__escape(FichothequeUtils.getTitle(satelliteCorpus, this.lang)).__colon()._SPAN().A(HA.href(BH.domain("edition").page("fiche-change").subset(satelliteCorpus).param("id", idValue).param("force", "1")).target(this.target).classes("global-button-Transparent action-FicheCreate").titleLocKey("_ label.edition.satellite_creation")).__(Button.ICON)._A();
        return true;
    }
}

