/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.conf.dom;

import fr.exemole.bdfserver.conf.ConfUtils;
import fr.exemole.bdfserver.conf.WebappDirs;
import java.io.File;
import java.util.HashMap;
import net.mapeadores.util.exceptions.InitException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfDOMReader {
    private final String servletContextName;
    private final File relativeDirectory;
    private File etcDirectory;
    private File varDirectory;

    public ConfDOMReader(String servletContextName, File relativeDirectory) {
        this.servletContextName = servletContextName;
        this.relativeDirectory = relativeDirectory;
    }

    public WebappDirs readConf(Element element_xml, boolean multiBdf) {
        File iniFile;
        String tagName;
        Element el;
        Node nd;
        int i;
        HashMap<String, File> customDirMap = new HashMap<String, File>();
        customDirMap.put("lib.extensions", new File(this.relativeDirectory, "WEB-INF" + File.separator + "extensions"));
        NodeList nodeList = element_xml.getChildNodes();
        int nodeLength = nodeList.getLength();
        for (i = 0; i < nodeLength; ++i) {
            nd = nodeList.item(i);
            if (!(nd instanceof Element)) continue;
            el = (Element)nd;
            tagName = el.getTagName();
            if (tagName.equals("etc-dir")) {
                this.etcDirectory = this.readMainDirectory(el);
                continue;
            }
            if (!tagName.equals("var-dir")) continue;
            this.varDirectory = this.readMainDirectory(el);
        }
        if (this.etcDirectory == null) {
            throw new InitException("Missing <etc-dir> element in bdfConfFile");
        }
        if (this.varDirectory == null) {
            throw new InitException("Missing <var-dir> element in bdfConfFile");
        }
        for (i = 0; i < nodeLength; ++i) {
            nd = nodeList.item(i);
            if (!(nd instanceof Element) || !(tagName = (el = (Element)nd).getTagName()).equals("dir")) continue;
            String dirKey = el.getAttribute("key");
            String path = el.getAttribute("path");
            if (dirKey.length() <= 0 || path.length() <= 0) continue;
            File directory = new File(path);
            if (!directory.isAbsolute()) {
                directory = new File(this.getRelativeDirectory(dirKey), path);
            }
            if (this.appendServletContext(el)) {
                directory = new File(directory, this.servletContextName);
            }
            customDirMap.put(dirKey, directory);
        }
        WebappDirs webappDirs = WebappDirs.build(multiBdf, this.etcDirectory, this.varDirectory, customDirMap);
        if (!multiBdf && (iniFile = ConfUtils.getMultiIniFile(webappDirs)).exists() && !iniFile.isDirectory()) {
            webappDirs = WebappDirs.build(true, this.etcDirectory, this.varDirectory, customDirMap);
        }
        return webappDirs;
    }

    private File readMainDirectory(Element el) {
        String path = el.getAttribute("path");
        if (path.length() == 0) {
            return null;
        }
        File directory = new File(path);
        if (!directory.isAbsolute()) {
            directory = new File(this.relativeDirectory, path);
        }
        if (this.appendServletContext(el)) {
            directory = new File(directory, this.servletContextName);
        }
        return directory;
    }

    private boolean appendServletContext(Element el) {
        String appendContextString = el.getAttribute("append-context").toLowerCase();
        boolean appendContext = false;
        if (appendContextString.equals("true")) {
            appendContext = true;
        }
        return appendContext;
    }

    private File getRelativeDirectory(String dirKey) {
        if (dirKey.startsWith("var.")) {
            return this.varDirectory;
        }
        if (dirKey.startsWith("etc.")) {
            return this.etcDirectory;
        }
        return this.relativeDirectory;
    }
}

