/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TemplateContentRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateContentRemove";
    public static final String PATH_PARAMNAME = "path";
    public static final String COMMANDKEY = "_ EXP-34";
    private TemplateKey templateKey;
    private String path;

    public TemplateContentRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TemplateDescription templateDescription = this.bdfServer.getTransformationManager().removeTemplateContent(this.templateKey, this.path, editOrigin);
        if (templateDescription != null) {
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templatecontentremove", this.templateKey.getKeyString(), this.path);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        this.templateKey = templateDescription.getTemplateKey();
        this.path = this.getMandatory(PATH_PARAMNAME);
        TemplateContentDescription templateContentDescription = templateDescription.getTemplateContentDescription(this.path);
        if (templateContentDescription == null) {
            throw BdfErrors.unknownParameterValue(PATH_PARAMNAME, this.path);
        }
        if (templateContentDescription.isMandatory()) {
            throw BdfErrors.unsupportedNotEditableParameterValue(PATH_PARAMNAME, this.path);
        }
    }
}

