/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class IncludeRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IncludeRemove";
    public static final String COMMANDKEY = "_ CRP-14";
    public static final String NAME_PARAMNAME = "name";
    private Corpus corpus;
    private String name;
    private UiComponents uiComponents;

    public IncludeRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().removeComponentUi(this.uiComponents, this.name);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.includeremove", this.name);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.name = this.getMandatory(NAME_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        UiComponent current = this.uiComponents.getUiComponent(this.name);
        if (current == null) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, this.name);
        }
        if (!(current instanceof IncludeUi)) {
            throw BdfErrors.wrongParameterValue(NAME_PARAMNAME, this.name);
        }
    }
}

