/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.MetadataEditor;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;

public abstract class AbstractPhrasesCommand
extends AbstractBdfCommand {
    public static final String NEWPHRASE_PARAMNAME = "newphrase";
    private final Map<String, LabelChange> phraseChangeMap = new HashMap<String, LabelChange>();
    private LabelChange titleLabelChange;
    private String newPhraseName;
    private LabelChange newPhraseLabelChange;

    public AbstractPhrasesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    protected boolean update(MetadataEditor metadataEditor) {
        boolean done = false;
        if (metadataEditor.changeLabels(null, this.titleLabelChange)) {
            done = true;
        }
        for (Map.Entry<String, LabelChange> entry : this.phraseChangeMap.entrySet()) {
            if (!metadataEditor.changeLabels(entry.getKey(), entry.getValue())) continue;
            done = true;
        }
        if (this.newPhraseName != null && metadataEditor.changeLabels(this.newPhraseName, this.newPhraseLabelChange)) {
            done = true;
        }
        return done;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkPhrasesParameters() throws ErrorMessageException {
        this.newPhraseName = this.requestHandler.getTrimedParameter(NEWPHRASE_PARAMNAME);
        if (!this.newPhraseName.isEmpty()) {
            if (!FichothequeUtils.isValidPhraseName(this.newPhraseName)) {
                this.newPhraseName = null;
                throw BdfErrors.error("_ error.wrong.phrasename", this.newPhraseName);
            }
            this.newPhraseLabelChange = this.requestHandler.getLabelChange("newphrase/");
        } else {
            this.newPhraseName = null;
        }
        this.titleLabelChange = this.requestHandler.getLabelChange("metatitle/");
        BdfCommandUtils.populatePhraseLabelChange(this.requestHandler.getRequestMap(), this.phraseChangeMap);
    }
}

