/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import net.mapeadores.util.primitives.BitmaskUtils;

public class BitmaskCounter {
    int[] counts = new int[32];
    int noemptybitmask = 0;

    public BitmaskCounter() {
    }

    public BitmaskCounter(BitmaskCounter maskCounter) {
        this.noemptybitmask = maskCounter.noemptybitmask;
        System.arraycopy(maskCounter.counts, 0, this.counts, 0, 32);
    }

    public boolean isEmpty() {
        return this.noemptybitmask == 0;
    }

    public boolean isEmptyForBitmask(int bitmask) {
        return (bitmask & this.noemptybitmask) == 0;
    }

    public int getNoEmptyBitmask() {
        return this.noemptybitmask;
    }

    public int getEmptyBitmask() {
        return ~this.noemptybitmask;
    }

    public int getCountAt(byte rang) {
        return this.counts[rang];
    }

    public int getCount(int bitmask) {
        if ((this.noemptybitmask & bitmask) == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            int puissance = BitmaskUtils.getBitValue(i);
            if ((bitmask & puissance) == 0) continue;
            count += this.counts[i];
        }
        return count;
    }

    public void increaseCount(int bitmask) {
        if (bitmask == 0) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            int puissance = BitmaskUtils.getBitValue(i);
            if ((bitmask & puissance) == 0) continue;
            int n = i;
            this.counts[n] = this.counts[n] + 1;
        }
        this.noemptybitmask |= bitmask;
    }

    public void decreaseCount(int bitmask) {
        if (bitmask == 0) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            int puissance = BitmaskUtils.getBitValue(i);
            if ((bitmask & puissance) == 0) continue;
            int n = i;
            this.counts[n] = this.counts[n] - 1;
            if (this.counts[i] > 0) continue;
            this.counts[i] = 0;
            this.noemptybitmask &= ~puissance;
        }
    }
}

