/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisationFactory;

public class ResourceMessageLocalisationFactory
extends MessageLocalisationFactory {
    protected void add(Class resourcesReference, Lang lang, String iniPath) {
        try (InputStreamReader reader = new InputStreamReader(resourcesReference.getResourceAsStream("resources/" + iniPath), "UTF-8");){
            HashMap<String, String> stringMap = new HashMap<String, String>();
            IniParser.parseIni((Reader)reader, stringMap);
            for (Map.Entry entry : stringMap.entrySet()) {
                this.addEntry((String)entry.getKey(), lang, (String)entry.getValue());
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public static ResourceMessageLocalisationFactory build(Class ... resourcesReferences) {
        ResourceMessageLocalisationFactory messageLocalisationFactory = new ResourceMessageLocalisationFactory();
        for (Class resourcesReference : resourcesReferences) {
            InputStream inputStream = resourcesReference.getResourceAsStream("resources/list.txt");
            if (inputStream == null) continue;
            try {
                String ligne;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((ligne = reader.readLine()) != null) {
                    String path;
                    int idx;
                    if (!(ligne = ligne.trim()).startsWith("l10n/") || !ligne.endsWith(".ini") || (idx = (path = ligne.substring(5)).indexOf(47)) <= 0) continue;
                    try {
                        Lang lang = Lang.parse(path.substring(0, idx));
                        messageLocalisationFactory.add(resourcesReference, lang, ligne);
                    }
                    catch (ParseException parseException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return messageLocalisationFactory;
    }
}

