/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exec;

import net.mapeadores.util.exec.Args;
import net.mapeadores.util.exec.ArgsBuilder;
import net.mapeadores.util.exec.ArgsDef;
import net.mapeadores.util.exec.CommandDef;
import net.mapeadores.util.exec.ParameterDef;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ArgsParser {
    private final ArgsDef argsDef;
    private final ArgsBuilder argsBuilder;
    private final String[] args;
    private final int argsLength;
    private boolean commandDone;

    private ArgsParser(ArgsDef argsDef, ArgsBuilder argsBuilder, String[] args) {
        this.argsDef = argsDef;
        this.argsBuilder = argsBuilder;
        this.args = args;
        this.argsLength = args.length;
    }

    public static Args parse(String[] args, ArgsDef argsDef) throws ErrorMessageException {
        ArgsBuilder argsBuilder = new ArgsBuilder(argsDef);
        ArgsParser parser = new ArgsParser(argsDef, argsBuilder, args);
        parser.parseAt(0);
        return argsBuilder.toArgs();
    }

    private void parseAt(int index) throws ErrorMessageException {
        if (index >= this.argsLength) {
            return;
        }
        String value = this.args[index];
        if (value.startsWith("--")) {
            int idx = value.indexOf(61);
            if (idx == -1) {
                this.argsBuilder.addParameter(value.substring(2));
            } else {
                this.argsBuilder.addParameter(value.substring(2, idx), value.substring(idx + 1));
            }
        } else if (!value.startsWith("-")) {
            if (!this.commandDone) {
                CommandDef commandDef = this.argsDef.getCommandDef(value);
                if (commandDef == null) {
                    throw new ErrorMessageException("_ error.unknown.args.command", value);
                }
                this.argsBuilder.setCommandDef(commandDef);
                this.commandDone = true;
            } else {
                this.argsBuilder.addValues(value);
            }
        } else {
            int valueLength = value.length();
            switch (valueLength) {
                case 1: {
                    throw new ErrorMessageException("_ error.unsupported.args.alonedash");
                }
                case 2: {
                    index = this.testUniqueParameter(index, value.charAt(1));
                    break;
                }
                default: {
                    for (int i = 1; i < valueLength; ++i) {
                        char parameterChar = value.charAt(i);
                        ParameterDef parameterDef = this.argsDef.getParameterDef(parameterChar);
                        if (parameterDef == null) {
                            throw new ErrorMessageException("_ error.unknown.args.parameter", "-" + parameterChar);
                        }
                        if (parameterDef.requireValue()) {
                            throw new ErrorMessageException("_ error.empty.args.parametervalue", "-" + parameterChar);
                        }
                        this.argsBuilder.addCharacterParameter(parameterDef.getLetter());
                    }
                }
            }
        }
        this.parseAt(index + 1);
    }

    private int testUniqueParameter(int index, char parameterChar) throws ErrorMessageException {
        ParameterDef parameterDef = this.argsDef.getParameterDef(parameterChar);
        if (parameterDef == null) {
            throw new ErrorMessageException("_ error.unknown.args.parameter", "-" + parameterChar);
        }
        if (parameterDef.requireValue()) {
            if (index == this.argsLength - 1) {
                throw new ErrorMessageException("_ error.empty.args.parametervalue", "-" + parameterChar);
            }
            String value = this.args[index + 1];
            if (value.startsWith("-")) {
                throw new ErrorMessageException("_ error.empty.args.parametervalue", "-" + parameterChar);
            }
            if (!parameterDef.isValidValue(value)) {
                throw new ErrorMessageException("_ error.wrong.args.parametervalue", "-" + parameterChar, value);
            }
            this.argsBuilder.addCharacterParameter(parameterDef.getLetter(), value);
            return index + 1;
        }
        this.argsBuilder.addCharacterParameter(parameterDef.getLetter());
        return index;
    }
}

