/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.exceptions;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.mapeadores.util.exceptions.ExceptionsUtils;
import org.xml.sax.SAXParseException;

public class NestedTransformerException
extends RuntimeException {
    private TransformerException transformerException;

    public NestedTransformerException(TransformerException te) {
        super(te);
        this.transformerException = te;
    }

    @Override
    public String getMessage() {
        return this.getTransformerMessage(this.transformerException);
    }

    public TransformerException geTransformerException() {
        return this.transformerException;
    }

    public TransformerException getTransformerException() {
        return this.transformerException;
    }

    private String getTransformerMessage(TransformerException te) {
        Throwable e = te.getCause();
        if (e != null && e instanceof TransformerException) {
            return this.getTransformerMessage((TransformerException)e);
        }
        StringBuilder buf = new StringBuilder();
        SourceLocator sourceLocator = te.getLocator();
        if (sourceLocator != null) {
            ExceptionsUtils.append(buf, sourceLocator.getPublicId(), sourceLocator.getSystemId(), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        } else if (e != null && e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            ExceptionsUtils.append(buf, spe);
        }
        if (e != null) {
            buf.append(e.getLocalizedMessage());
        } else {
            buf.append(te.getMessageAndLocation());
        }
        return buf.toString();
    }
}

