/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.StylesXMLPart;
import net.mapeadores.opendocument.io.odtable.CellStyle;
import net.mapeadores.opendocument.io.odtable.DateStyleXMLPart;
import net.mapeadores.opendocument.io.odtable.OdColumn;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.StyleKey;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.xml.XMLWriter;

public class StyleManagerBuilder {
    private static final String COLUMNSTYLE_PREFIX = "co";
    private static final String CELLSTYLE_PREFIX = "ce";
    private static final String DATASTYLE_PREFIX = "N";
    private static final String DEFAULT_CELLSTYLE_NAME = "Default";
    private final List<String> columnStyleNameList = new ArrayList<String>();
    private final Map<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>();
    private final Map<StyleKey, CellStyle> cellStyleNameMap = new LinkedHashMap<StyleKey, CellStyle>();
    private final Map<ExtendedCurrency, Integer> currencyNumberMap = new LinkedHashMap<ExtendedCurrency, Integer>();
    private final Map<String, Integer> patternNumberMap = new LinkedHashMap<String, Integer>();
    private ElementMaps elementMaps = null;
    private int columnStyleNumber = 1;
    private int cellStyleNumber = 1;
    private int dataStyleNumber = 101;

    public StyleManagerBuilder putTableDef(String tableName, OdTableDef odTableDef) {
        if (!this.tableInfoMap.containsKey(tableName)) {
            this.tableInfoMap.put(tableName, new TableInfo(odTableDef));
        }
        return this;
    }

    public StyleManagerBuilder addTableDef(OdTableDef odTableDef) {
        String tableName = odTableDef.getTableName();
        if (!this.tableInfoMap.containsKey(tableName)) {
            this.tableInfoMap.put(tableName, new TableInfo(odTableDef));
        }
        return this;
    }

    public StyleManagerBuilder setElementMaps(ElementMaps elementMaps) {
        this.elementMaps = elementMaps;
        return this;
    }

    public StyleManager toStyleManager() {
        return new InternalStyleManager();
    }

    private String getNewColumnStyleName() {
        String styleName = COLUMNSTYLE_PREFIX + String.valueOf(this.columnStyleNumber);
        ++this.columnStyleNumber;
        this.columnStyleNameList.add(styleName);
        return styleName;
    }

    private CellStyle initCellStyle(StyleKey styleKey) {
        CellStyle cellStyle = this.cellStyleNameMap.get(styleKey);
        if (cellStyle != null) {
            return cellStyle;
        }
        String name = CELLSTYLE_PREFIX + this.cellStyleNumber;
        ++this.cellStyleNumber;
        String dataStyleName = null;
        switch (styleKey.getStyleFamliy()) {
            case 1: {
                int number;
                String pattern = styleKey.getPattern();
                if (this.patternNumberMap.containsKey(pattern)) {
                    number = this.patternNumberMap.get(pattern);
                } else {
                    number = this.dataStyleNumber++;
                    this.patternNumberMap.put(pattern, number);
                }
                dataStyleName = DATASTYLE_PREFIX + number;
                break;
            }
            case 2: {
                int number;
                ExtendedCurrency currency = styleKey.getCurrency();
                if (this.currencyNumberMap.containsKey(currency)) {
                    number = this.currencyNumberMap.get(currency);
                } else {
                    number = this.dataStyleNumber++;
                    this.currencyNumberMap.put(currency, number);
                }
                dataStyleName = DATASTYLE_PREFIX + number;
                break;
            }
        }
        cellStyle = new CellStyle(name, dataStyleName, styleKey.getParentStyleName());
        this.cellStyleNameMap.put(styleKey, cellStyle);
        return cellStyle;
    }

    public static StyleManagerBuilder init() {
        return new StyleManagerBuilder();
    }

    private class TableInfo {
        private final List<OdColumn> odColumnList = new ArrayList<OdColumn>();

        private TableInfo(OdTableDef odTableDef) {
            for (OdColumnDef columnDef : odTableDef.getOdColumnDefList()) {
                StyleKey defaultStyleKey = columnDef.getDefaultStyleKey();
                String customStyleName = columnDef.getCustomStyleName();
                String columnStyleName = customStyleName != null ? customStyleName : StyleManagerBuilder.this.getNewColumnStyleName();
                CellStyle defaultCellStyle = StyleManagerBuilder.this.initCellStyle(defaultStyleKey);
                this.odColumnList.add(new OdColumn(columnStyleName, defaultStyleKey, defaultCellStyle));
            }
        }

        private StyleKey getDefaultStyleKey(int columnNumber) {
            if (columnNumber > 0 && columnNumber <= this.odColumnList.size()) {
                return this.odColumnList.get(columnNumber - 1).getDefaultStyleKey();
            }
            return null;
        }
    }

    private class InternalStyleManager
    implements StyleManager {
        private InternalStyleManager() {
        }

        @Override
        public String getDateCellStyleName(String tableName, int columnNumber, String pattern, String customStyleName) {
            StyleKey styleKey;
            StyleKey defaultStyleKey = this.getDefaultStyleKey(tableName, columnNumber);
            if (defaultStyleKey == null) {
                if (pattern == null) {
                    pattern = "y-MM-dd";
                }
                styleKey = StyleKey.newDateInstance(pattern, customStyleName);
            } else if (!defaultStyleKey.isDateStyle()) {
                if (pattern == null) {
                    pattern = "y-MM-dd";
                }
                styleKey = customStyleName != null ? StyleKey.newDateInstance(pattern, customStyleName) : StyleKey.newDateInstance(pattern, defaultStyleKey.getParentStyleName());
            } else if (customStyleName == null) {
                styleKey = pattern == null ? defaultStyleKey : StyleKey.newDateInstance(pattern, defaultStyleKey.getParentStyleName());
            } else {
                if (pattern == null) {
                    pattern = defaultStyleKey.getPattern();
                }
                styleKey = StyleKey.newDateInstance(pattern, customStyleName);
            }
            if (defaultStyleKey != null && styleKey.equals(defaultStyleKey)) {
                return null;
            }
            return this.getCellStyleName(styleKey);
        }

        @Override
        public String getStandardCellStyleName(String tableName, int columnNumber, String customStyleName) {
            StyleKey styleKey;
            StyleKey defaultStyleKey = this.getDefaultStyleKey(tableName, columnNumber);
            if (defaultStyleKey == null) {
                if (customStyleName == null) {
                    return null;
                }
                styleKey = StyleKey.newIsoDateInstance(customStyleName);
            } else if (!defaultStyleKey.isStandardStyle()) {
                if (customStyleName != null) {
                    styleKey = StyleKey.newStandardInstance(customStyleName);
                } else {
                    if (defaultStyleKey.getParentStyleName() == null) {
                        return null;
                    }
                    styleKey = StyleKey.newStandardInstance(defaultStyleKey.getParentStyleName());
                }
            } else {
                styleKey = customStyleName == null ? defaultStyleKey : StyleKey.newStandardInstance(customStyleName);
            }
            if (defaultStyleKey != null && styleKey.equals(defaultStyleKey)) {
                return null;
            }
            return this.getCellStyleName(styleKey);
        }

        @Override
        public String getCurrencyCellStyleName(String tableName, int columnNumber, ExtendedCurrency currency, String customStyleName) {
            StyleKey defaultStyleKey = this.getDefaultStyleKey(tableName, columnNumber);
            StyleKey styleKey = defaultStyleKey == null ? StyleKey.newCurrencyInstance(currency, customStyleName) : (!defaultStyleKey.isCurrencyStyle() ? (customStyleName != null ? StyleKey.newCurrencyInstance(currency, customStyleName) : StyleKey.newCurrencyInstance(currency, defaultStyleKey.getParentStyleName())) : (customStyleName == null ? StyleKey.newCurrencyInstance(currency, defaultStyleKey.getParentStyleName()) : StyleKey.newCurrencyInstance(currency, customStyleName)));
            if (defaultStyleKey != null && styleKey.equals(defaultStyleKey)) {
                return null;
            }
            return this.getCellStyleName(styleKey);
        }

        @Override
        public List<OdColumn> getOdColumnList(String tableName) {
            TableInfo tableInfo = (TableInfo)StyleManagerBuilder.this.tableInfoMap.get(tableName);
            if (tableInfo == null) {
                return null;
            }
            return tableInfo.odColumnList;
        }

        @Override
        public String getCellStyleName(StyleKey styleKey) {
            CellStyle cellStyle = StyleManagerBuilder.this.initCellStyle(styleKey);
            return cellStyle.getName();
        }

        @Override
        public void insertAutomaticStyles(XMLWriter xmlWriter) throws IOException {
            String dataStyleName;
            int number;
            if (StyleManagerBuilder.this.elementMaps != null) {
                StylesXMLPart stylesPart = new StylesXMLPart(xmlWriter);
                stylesPart.insertAutomaticStyles(StyleManagerBuilder.this.elementMaps, true);
            }
            DateStyleXMLPart dateStyleXMLPart = new DateStyleXMLPart(xmlWriter);
            for (String string : StyleManagerBuilder.this.columnStyleNameList) {
                boolean done = false;
                if (StyleManagerBuilder.this.elementMaps != null && StyleManagerBuilder.this.elementMaps.getElement("col", string, false) != null) {
                    done = true;
                }
                if (done) continue;
                OdXML.openStyle(xmlWriter, string, "table-column", null);
                xmlWriter.startOpenTag("style:table-column-properties").addAttribute("style:column-width", "3.5cm").closeEmptyTag();
                OdXML.closeStyle(xmlWriter);
            }
            for (Map.Entry entry : StyleManagerBuilder.this.patternNumberMap.entrySet()) {
                String pattern = (String)entry.getKey();
                number = (Integer)entry.getValue();
                dataStyleName = StyleManagerBuilder.DATASTYLE_PREFIX + number;
                dateStyleXMLPart.writeFromJavaPattern(dataStyleName, pattern);
            }
            for (Map.Entry entry : StyleManagerBuilder.this.currencyNumberMap.entrySet()) {
                ExtendedCurrency currency = (ExtendedCurrency)entry.getKey();
                number = (Integer)entry.getValue();
                dataStyleName = StyleManagerBuilder.DATASTYLE_PREFIX + number;
                int fractionDigits = currency.getDefaultFractionDigits();
                String symbol = currency.getSymbol();
                boolean before = currency.isSymbolBefore();
                xmlWriter.startOpenTag("number:currency-style").addAttribute("style:name", dataStyleName + "P0").addAttribute("style:volatile", "true").endOpenTag();
                if (before) {
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("number:number").addAttribute("number:decimal-places", fractionDigits).addAttribute("number:min-integer-digits", "1").addAttribute("number:grouping", "true").closeEmptyTag();
                if (!before) {
                    xmlWriter.addSimpleElement("number:text", " ");
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.closeTag("number:currency-style");
                xmlWriter.startOpenTag("number:currency-style").addAttribute("style:name", dataStyleName).endOpenTag();
                xmlWriter.startOpenTag("style:text-properties").addAttribute("fo:color", "#ff0000").closeEmptyTag();
                xmlWriter.addSimpleElement("number:text", "-");
                if (before) {
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("number:number").addAttribute("number:decimal-places", fractionDigits).addAttribute("number:min-integer-digits", "1").addAttribute("number:grouping", "true").closeEmptyTag();
                if (!before) {
                    xmlWriter.addSimpleElement("number:text", " ");
                    xmlWriter.addSimpleElement("number:currency-symbol", symbol);
                }
                xmlWriter.startOpenTag("style:map").addAttribute("style:condition", "value()>=0").addAttribute("style:apply-style-name", dataStyleName + "P0").closeEmptyTag();
                xmlWriter.closeTag("number:currency-style");
            }
            for (CellStyle cellStyle : StyleManagerBuilder.this.cellStyleNameMap.values()) {
                String parentStyleName = cellStyle.getParentStyleName();
                if (parentStyleName == null) {
                    parentStyleName = StyleManagerBuilder.DEFAULT_CELLSTYLE_NAME;
                }
                OdXML.startStyleOpenTag(xmlWriter, cellStyle.getName(), "table-cell", parentStyleName).addAttribute("style:data-style-name", cellStyle.getDataStyleName()).closeEmptyTag();
            }
        }

        private StyleKey getDefaultStyleKey(String tableName, int columnNumber) {
            TableInfo tableInfo = (TableInfo)StyleManagerBuilder.this.tableInfoMap.get(tableName);
            if (tableInfo != null) {
                return tableInfo.getDefaultStyleKey(columnNumber);
            }
            return null;
        }
    }
}

