/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

import net.mapeadores.opendocument.elements.ListLevelElement;
import net.mapeadores.opendocument.elements.OdElement;
import net.mapeadores.opendocument.elements.OdElementUtils;

public class ListStyleElement
extends OdElement {
    private final String styleName;
    private final ListLevelElement[] listLevelElementArray = new ListLevelElement[10];
    private final short listLevelType;

    public ListStyleElement(String styleName, short listLevelType) {
        String displayName = OdElementUtils.toDisplayNameValue(styleName);
        this.styleName = OdElementUtils.checkStyleNameValue(styleName);
        this.listLevelType = listLevelType;
        this.putAttribute("display-name", displayName);
    }

    @Override
    public int[] getAvalaibleTypeArray() {
        int[] result = new int[]{11};
        return result;
    }

    public ListLevelElement getListLevelElement(int level) {
        return this.listLevelElementArray[level - 1];
    }

    public ListLevelElement getOrCreateListLevelElement(int level) {
        ListLevelElement result = this.listLevelElementArray[level - 1];
        if (result == null) {
            this.listLevelElementArray[level - 1] = result = new ListLevelElement(this.listLevelType, level);
        }
        return result;
    }

    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public void importAttributes(OdElement importElement) {
        super.importAttributes(importElement);
        if (importElement instanceof ListStyleElement) {
            this.importListLevel((ListStyleElement)importElement);
        }
    }

    private void importListLevel(ListStyleElement other) {
        for (int i = 0; i < 10; ++i) {
            ListLevelElement importLevel = other.listLevelElementArray[i];
            if (importLevel == null) continue;
            ListLevelElement current = this.listLevelElementArray[i];
            if (current == null) {
                this.listLevelElementArray[i] = importLevel;
                continue;
            }
            current.importAttributes(importLevel);
        }
    }
}

