/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.importation;

import java.io.IOException;
import java.util.List;
import net.fichotheque.importation.TiesImport;
import net.fichotheque.include.IncludeKey;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class TiesImportXMLPart
extends XMLPart {
    public TiesImportXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addTiesImport(TiesImport tiesImport) throws IOException {
        List<TiesImport.TieImport> list;
        List<TiesImport.TieImport> replaceList;
        List<IncludeKey> removedIncludeKeyList = tiesImport.getRemovedIncludeKeyList();
        if (!removedIncludeKeyList.isEmpty()) {
            this.startOpenTag("ties");
            this.addAttribute("type", "remove");
            this.endOpenTag();
            for (IncludeKey includeKey : removedIncludeKeyList) {
                this.addSimpleElement("include-key", includeKey.getKeyString());
            }
            this.closeTag("ties");
        }
        if (!(replaceList = tiesImport.getReplaceTieImportList()).isEmpty()) {
            this.startOpenTag("ties");
            this.addAttribute("type", "replace");
            this.endOpenTag();
            for (TiesImport.TieImport tieImport : replaceList) {
                this.addTieImport(tieImport);
            }
            this.closeTag("ties");
        }
        if (!(list = tiesImport.getAppendTieImportList()).isEmpty()) {
            this.startOpenTag("ties");
            this.addAttribute("type", "append");
            this.endOpenTag();
            for (TiesImport.TieImport tieImport : list) {
                this.addTieImport(tieImport);
            }
            this.closeTag("ties");
        }
    }

    private void addTieImport(TiesImport.TieImport tieImport) throws IOException {
        this.startOpenTag("tie");
        this.addAttribute("include-key", tieImport.getIncludeKey().getKeyString());
        this.addAttribute("weight", tieImport.getWeight());
        TiesImport.Other other = tieImport.getOther();
        if (other instanceof TiesImport.IdOther) {
            this.addAttribute("id", ((TiesImport.IdOther)other).getOtherId());
        } else if (other instanceof TiesImport.LabelOther) {
            Label label = ((TiesImport.LabelOther)other).getLabel();
            this.addAttribute("lang", label.getLang().toString());
            this.addAttribute("label", label.getLabelString());
        } else if (other instanceof TiesImport.IdalphaOther) {
            this.addAttribute("idalpha", ((TiesImport.IdalphaOther)other).getIdalpha());
        }
        this.closeEmptyTag();
    }
}

