/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.time.format.FormatStyle;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.extraction.FilterParameters;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.format.FormatConstants;

public abstract class ExtractOptions {
    public static ExtractOptions build(CorpusField corpusField, FilterParameters filterParameters) {
        switch (corpusField.getFicheItemType()) {
            case "image": 
            case "link": {
                return new Ref(corpusField.getStringOption("baseUrl"));
            }
            case "date": {
                String truncateDateType = filterParameters.getFirstValue("datelabeltruncate");
                if (truncateDateType != null) {
                    try {
                        truncateDateType = FuzzyDate.checkDateType(truncateDateType);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                FormatStyle formatStyle = null;
                String dateStyle = filterParameters.getFirstValue("datestyle");
                if (dateStyle != null) {
                    formatStyle = FormatConstants.getMatchingFormatStyle(dateStyle);
                }
                if (truncateDateType != null || formatStyle != null) {
                    return new Date(truncateDateType, formatStyle);
                }
                return null;
            }
            case "amount": {
                String paramValue = filterParameters.getFirstValue("amountsubunit");
                if (paramValue == null || !paramValue.equals("force")) break;
                return new Amount(true);
            }
        }
        return null;
    }

    public static class Ref
    extends ExtractOptions {
        private final String baseUrl;

        public Ref(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }
    }

    public static class Date
    extends ExtractOptions {
        private final String labelType;
        private final FormatStyle formatStyle;

        public Date(String labelType, FormatStyle formatStyle) {
            this.labelType = labelType;
            this.formatStyle = formatStyle;
        }

        public String getTruncateDateType() {
            return this.labelType;
        }

        public FormatStyle getStyle() {
            return this.formatStyle;
        }
    }

    public static class Amount
    extends ExtractOptions {
        private final boolean forceSubunit;

        public Amount(boolean forceSubunit) {
            this.forceSubunit = forceSubunit;
        }

        public boolean isForceSubunit() {
            return this.forceSubunit;
        }
    }
}

