/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.StatusCondition;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.selection.FicheConditionPredicateFactory;
import net.fichotheque.utils.selection.FilteredJunctionBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

class MotcleSelectEngine {
    private final Lang lang;
    private final RangeCondition idRangeCondition;
    private final RangeCondition levelRangeCondition;
    private final StatusCondition statusCondition;
    private final FieldTest fieldTest;
    private final JunctionCondition junctionCondition;
    private final Predicate<SubsetItem> ficheConditionPredicate;

    MotcleSelectEngine(MotcleQuery motcleQuery, JunctionCondition junctionCondition, SelectionContext selectionContext) {
        this.lang = selectionContext.getWorkingLang();
        this.idRangeCondition = motcleQuery.getIdRangeCondition();
        this.levelRangeCondition = motcleQuery.getLevelRangeCondition();
        this.statusCondition = motcleQuery.getStatusCondition();
        MotcleQuery.ContentCondition contentCondition = motcleQuery.getContentCondition();
        this.fieldTest = contentCondition == null ? null : this.initFieldTest(contentCondition, this.lang);
        this.junctionCondition = junctionCondition;
        FicheCondition ficheCondition = motcleQuery.getFicheCondition();
        this.ficheConditionPredicate = ficheCondition != null ? FicheConditionPredicateFactory.newInstance(selectionContext, ficheCondition) : null;
    }

    private FieldTest initFieldTest(MotcleQuery.ContentCondition contentCondition, Lang lang) {
        short conditionType = ConditionsUtils.getConditionType(contentCondition.getTextCondition());
        switch (conditionType) {
            case 2: {
                return new ConstantFieldTest(false);
            }
            case 0: 
            case 1: {
                return new ConstantFieldTest(true);
            }
            case 4: {
                return new NotEmptyFieldTest(true);
            }
            case 3: {
                return new NotEmptyFieldTest(false);
            }
            case 5: 
            case 6: {
                return new ContentFieldTest(contentCondition.getScope(), contentCondition.getTextCondition(), lang);
            }
        }
        throw new SwitchException("state = " + conditionType);
    }

    boolean isSelected(Motcle motcle) {
        if (this.statusCondition != null && !this.statusCondition.accept(motcle.getStatus())) {
            return false;
        }
        if (this.levelRangeCondition != null && !this.levelRangeCondition.accept(motcle.getLevel())) {
            return false;
        }
        if (this.idRangeCondition != null && !this.idRangeCondition.accept(motcle.getId())) {
            return false;
        }
        if (this.ficheConditionPredicate != null && !this.ficheConditionPredicate.test(motcle)) {
            return false;
        }
        return this.fieldTest == null || this.fieldTest.isSelected(motcle);
    }

    void filter(Motcle motcle, FilteredJunctionBuilder builder) {
        if (!this.isSelected(motcle)) {
            return;
        }
        builder.testCondition(this.junctionCondition);
    }

    private abstract class FieldTest {
        private FieldTest() {
        }

        public abstract boolean isSelected(Motcle var1);
    }

    private class ConstantFieldTest
    extends FieldTest {
        private final boolean constantAnswer;

        private ConstantFieldTest(boolean constantAnswer) {
            this.constantAnswer = constantAnswer;
        }

        @Override
        public boolean isSelected(Motcle motcle) {
            return this.constantAnswer;
        }
    }

    private class NotEmptyFieldTest
    extends FieldTest {
        private final boolean notEmptyWanted;

        private NotEmptyFieldTest(boolean notEmpty) {
            this.notEmptyWanted = notEmpty;
        }

        @Override
        public boolean isSelected(Motcle motcle) {
            Label label = motcle.getLabels().getLabel(MotcleSelectEngine.this.lang);
            if (label != null) {
                return this.notEmptyWanted;
            }
            return !this.notEmptyWanted;
        }
    }

    private class ContentFieldTest
    extends FieldTest {
        private final String scope;
        private final TextTestEngine textTestEngine;

        private ContentFieldTest(String scope, TextCondition fieldCondition, Lang lang) {
            this.scope = scope;
            this.textTestEngine = TextTestEngine.newInstance(fieldCondition, lang);
        }

        @Override
        public boolean isSelected(Motcle motcle) {
            String idalpha;
            this.textTestEngine.start();
            if (!this.scope.equals("idalpha_without") && (idalpha = motcle.getIdalpha()) != null) {
                this.textTestEngine.addString(idalpha);
                if (this.scope.equals("idalpha_only")) {
                    return this.textTestEngine.getResult();
                }
            }
            if (!this.textTestEngine.canStop()) {
                this.textTestEngine.addString(motcle.getLabelString(MotcleSelectEngine.this.lang, ""));
            }
            return this.textTestEngine.getResult();
        }
    }
}

