/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.thesaurus.Motcle;

public final class EligibilityUtils {
    public static final Predicate<SubsetItem> ALL_SUBSETITEM_PREDICATE = subsetItem -> true;
    public static final Predicate<SubsetItem> NONE_SUBSETITEM_PREDICATE = subsetItem -> false;
    public static final Predicate<FicheMeta> ALL_FICHE_PREDICATE = ficheMeta -> true;
    public static final Predicate<Motcle> ALL_MOTCLE_PREDICATE = motcle -> true;
    public static final Predicate<Subset> ALL_SUBSET_PREDICATE = subset -> true;
    public static final SubsetEligibility ALL_SUBSET_ELIGIBILITY = new AllSubsetEligibility();
    public static final SubsetEligibility NONE_SUBSET_ELIGIBILITY = new NoneSubsetEligibility();

    private EligibilityUtils() {
    }

    public static Predicate<SubsetItem> toPredicate(Set<SubsetItem> subsetItemSet) {
        return new SetPredicate(subsetItemSet);
    }

    public static Predicate<FicheMeta> toFichePredicate(Set<FicheMeta> ficheMetaSet) {
        return new FicheSetPredicate(ficheMetaSet);
    }

    public static Predicate<FicheMeta> toFichePredicate(Predicate<SubsetItem> predicate) {
        return ficheMeta -> predicate.test((SubsetItem)ficheMeta);
    }

    public static Predicate<Motcle> toMotclePredicate(Set<Motcle> motcleSet) {
        return new MotcleSetPredicate(motcleSet);
    }

    public static Predicate<SubsetItem> merge(Predicate<FicheMeta> fichePredicate, Predicate<Motcle> motclePredicate) {
        return new MergePredicate(fichePredicate, motclePredicate);
    }

    public static SubsetEligibility exclude(Subset subset) {
        return new ExcludeSubsetEligibility(subset.getSubsetKey());
    }

    private static class SetPredicate
    implements Predicate<SubsetItem> {
        private final Set<SubsetItem> subsetItemSet;

        private SetPredicate(Set<SubsetItem> subsetItemSet) {
            this.subsetItemSet = subsetItemSet;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.subsetItemSet.contains(subsetItem);
        }
    }

    private static class FicheSetPredicate
    implements Predicate<FicheMeta> {
        private final Set<FicheMeta> ficheMetaSet;

        private FicheSetPredicate(Set<FicheMeta> ficheMetaSet) {
            this.ficheMetaSet = ficheMetaSet;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return this.ficheMetaSet.contains(ficheMeta);
        }
    }

    private static class MotcleSetPredicate
    implements Predicate<Motcle> {
        private final Set<Motcle> motcleSet;

        private MotcleSetPredicate(Set<Motcle> motcleSet) {
            this.motcleSet = motcleSet;
        }

        @Override
        public boolean test(Motcle motcle) {
            return this.motcleSet.contains(motcle);
        }
    }

    private static class MergePredicate
    implements Predicate<SubsetItem> {
        private final Predicate<FicheMeta> fichePredicate;
        private final Predicate<Motcle> motclePredicate;

        private MergePredicate(Predicate<FicheMeta> fichePredicate, Predicate<Motcle> motclePredicate) {
            this.fichePredicate = fichePredicate == null ? ALL_FICHE_PREDICATE : fichePredicate;
            this.motclePredicate = motclePredicate == null ? ALL_MOTCLE_PREDICATE : motclePredicate;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            if (subsetItem instanceof FicheMeta) {
                return this.fichePredicate.test((FicheMeta)subsetItem);
            }
            if (subsetItem instanceof Motcle) {
                return this.motclePredicate.test((Motcle)subsetItem);
            }
            return true;
        }
    }

    private static class ExcludeSubsetEligibility
    implements SubsetEligibility {
        private final SubsetKey excludeSubsetKey;

        private ExcludeSubsetEligibility(SubsetKey subsetKey) {
            this.excludeSubsetKey = subsetKey;
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            return !subsetKey.equals(this.excludeSubsetKey);
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            if (subset.getSubsetKey().equals(this.excludeSubsetKey)) {
                return NONE_SUBSETITEM_PREDICATE;
            }
            return ALL_SUBSETITEM_PREDICATE;
        }
    }

    private static class AllSubsetEligibility
    implements SubsetEligibility {
        private AllSubsetEligibility() {
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            return true;
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            return ALL_SUBSETITEM_PREDICATE;
        }
    }

    private static class NoneSubsetEligibility
    implements SubsetEligibility {
        private NoneSubsetEligibility() {
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            return false;
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            return NONE_SUBSETITEM_PREDICATE;
        }
    }
}

