/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Liaison;
import net.fichotheque.junction.Tie;
import net.fichotheque.tools.junction.JunctionChangeBuilder;
import net.fichotheque.tools.junction.JunctionChangesBuilder;
import net.fichotheque.utils.JunctionUtils;

class DocumentOrderManager {
    private final SubsetItem mainSubsetItem;
    private final Addenda addenda;
    private final String mode;
    private final int weight;
    private final List<Object> orderList = new ArrayList<Object>();

    DocumentOrderManager(SubsetItem mainSubsetItem, Addenda addenda, String mode, int weight) {
        this.mainSubsetItem = mainSubsetItem;
        this.addenda = addenda;
        this.mode = mode;
        this.weight = weight;
    }

    void add(Object orderObject) {
        this.orderList.add(orderObject);
    }

    void replace(String basename, int newDocumentId) {
        int idx = this.orderList.indexOf(basename);
        this.orderList.set(idx, newDocumentId);
    }

    void save(JunctionEditor junctionEditor) {
        EditEngine editEngine = new EditEngine();
        editEngine.initLiaisonInfos();
        editEngine.scanNewOrder(this.orderList);
        JunctionChanges junctionChanges = editEngine.toJunctionChanges();
        junctionEditor.updateJunctions(this.mainSubsetItem, junctionChanges);
    }

    private class EditEngine {
        private final List<LiaisonInfo> infoList = new ArrayList<LiaisonInfo>();
        private final Map<Integer, LiaisonInfo> infoByIdMap = new HashMap<Integer, LiaisonInfo>();

        private EditEngine() {
        }

        private void initLiaisonInfos() {
            Collection<Liaison> liaisons = JunctionUtils.filter(DocumentOrderManager.this.mainSubsetItem.getJunctions(DocumentOrderManager.this.addenda), DocumentOrderManager.this.mode, DocumentOrderManager.this.weight);
            int currentIndex = 0;
            for (Liaison liaison : liaisons) {
                LiaisonInfo liaisonInfo = new LiaisonInfo(liaison, currentIndex);
                this.infoList.add(liaisonInfo);
                this.infoByIdMap.put(liaison.getSubsetItem().getId(), liaisonInfo);
            }
        }

        private void scanNewOrder(List<Object> orderList) {
            int newIndex = 0;
            for (Object obj : orderList) {
                LiaisonInfo liaisonInfo;
                if (!(obj instanceof Integer) || (liaisonInfo = this.infoByIdMap.get((Integer)obj)) == null) continue;
                this.initPosition(liaisonInfo, newIndex);
                ++newIndex;
            }
            for (LiaisonInfo liaisonInfo : this.infoList) {
                if (liaisonInfo.newIndex != -1) continue;
                this.initPosition(liaisonInfo, newIndex);
                ++newIndex;
            }
        }

        private void initPosition(LiaisonInfo liaisonInfo, int newIndex) {
            liaisonInfo.newIndex = newIndex;
            liaisonInfo.newPosition = this.infoList.get(newIndex).currentPosition;
        }

        private JunctionChanges toJunctionChanges() {
            JunctionChangesBuilder builder = new JunctionChangesBuilder();
            for (LiaisonInfo liaisonInfo : this.infoList) {
                JunctionChangeBuilder changeBuilder = new JunctionChangeBuilder();
                changeBuilder.addTie(liaisonInfo.getNewTie());
                builder.addEntry(liaisonInfo.liaison.getSubsetItem(), changeBuilder.toJunctionChange());
            }
            return builder.toJunctionChanges();
        }
    }

    private static class LiaisonInfo {
        private final Liaison liaison;
        private final int currentPosition;
        private final int currentIndex;
        private int newIndex = -1;
        private int newPosition = -1;

        private LiaisonInfo(Liaison liaison, int currentIndex) {
            this.liaison = liaison;
            this.currentPosition = liaison.getPosition();
            this.currentIndex = currentIndex;
        }

        private Tie getNewTie() {
            int position2;
            int position1;
            Tie tie = this.liaison.getTie();
            if (this.liaison.getPositionNumber() == 1) {
                position1 = this.newPosition;
                position2 = tie.getPosition2();
            } else {
                position1 = tie.getPosition1();
                position2 = this.newPosition;
            }
            return JunctionUtils.toTie(tie.getMode(), tie.getWeight(), position1, position2);
        }
    }
}

