/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.tools.importation.parsers.Row;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Idalpha;

public class IdalphaHandler {
    private int uniqueIndex = -1;
    private List<Integer> indexList;

    public boolean addIndex(int index) {
        if (index == -1) {
            this.uniqueIndex = index;
        } else {
            this.uniqueIndex = -2;
            if (this.indexList == null) {
                this.indexList = new ArrayList<Integer>();
            }
            this.indexList.add(index);
        }
        return true;
    }

    public String getIdalpha(Row row, boolean errorIfEmpty) throws ErrorMessageException {
        int columnCount = row.getColumnCount();
        CleanedString cs = null;
        if (this.uniqueIndex > -1) {
            if (this.uniqueIndex < columnCount) {
                cs = CleanedString.newInstance(row.getColumnValue(this.uniqueIndex));
            }
        } else {
            StringBuilder buf = new StringBuilder();
            int indexCount = this.indexList.size();
            for (int i = 0; i < indexCount; ++i) {
                String val;
                int index = this.indexList.get(i);
                if (index >= columnCount || (val = row.getColumnValue(index)) == null) continue;
                buf.append(val);
            }
            cs = CleanedString.newInstance(buf.toString());
        }
        if (cs == null) {
            if (errorIfEmpty) {
                throw new ErrorMessageException("_ error.empty.idalpha");
            }
            return null;
        }
        String idalpha = cs.toString();
        if (!Idalpha.isValid(idalpha)) {
            throw new ErrorMessageException("_ error.wrong.idalpha", idalpha);
        }
        return idalpha;
    }
}

