/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import net.fichotheque.importation.TiesImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.utils.FichothequeUtils;

public class TiesImportBuilder {
    private final Set<IncludeKey> removedIncludeKeySet = new HashSet<IncludeKey>();
    private final Set<IncludeKey> replaceIncludeKeySet = new HashSet<IncludeKey>();
    private final List<TiesImport.TieImport> replaceList = new ArrayList<TiesImport.TieImport>();
    private final List<TiesImport.TieImport> appendList = new ArrayList<TiesImport.TieImport>();

    public void addRemovedIncludeKey(IncludeKey includeKey) {
        if (!this.replaceIncludeKeySet.contains(includeKey)) {
            this.removedIncludeKeySet.add(includeKey);
        }
    }

    public void addReplaceTieImport(TiesImport.TieImport tieImport) {
        IncludeKey includeKey = tieImport.getIncludeKey();
        this.removedIncludeKeySet.remove(includeKey);
        this.replaceIncludeKeySet.add(includeKey);
        this.replaceList.add(tieImport);
    }

    public void addAppendTieImport(TiesImport.TieImport tieImport) {
        this.appendList.add(tieImport);
    }

    public void merge(TiesImportBuilder otherTiesImportBuilder) {
        for (IncludeKey otherIncludeKey : otherTiesImportBuilder.removedIncludeKeySet) {
            this.addRemovedIncludeKey(otherIncludeKey);
        }
        for (TiesImport.TieImport tieImport : otherTiesImportBuilder.replaceList) {
            this.addReplaceTieImport(tieImport);
        }
        for (TiesImport.TieImport tieImport : otherTiesImportBuilder.appendList) {
            this.addAppendTieImport(tieImport);
        }
    }

    public TiesImport toTiesImport() {
        List<IncludeKey> removedIncludeKeyList = FichothequeUtils.wrap(this.removedIncludeKeySet.toArray(new IncludeKey[this.removedIncludeKeySet.size()]));
        return new InternalTiesImport(removedIncludeKeyList, TiesImportBuilder.wrap(this.replaceList), TiesImportBuilder.wrap(this.appendList));
    }

    private static List<TiesImport.TieImport> wrap(List<TiesImport.TieImport> list) {
        return new TieImportList(list.toArray(new TiesImport.TieImport[list.size()]));
    }

    private static class InternalTiesImport
    implements TiesImport {
        private final List<IncludeKey> removedIncludeKeyList;
        private final List<TiesImport.TieImport> replaceList;
        private final List<TiesImport.TieImport> appendList;

        private InternalTiesImport(List<IncludeKey> removedIncludeKeyList, List<TiesImport.TieImport> replaceList, List<TiesImport.TieImport> appendList) {
            this.removedIncludeKeyList = removedIncludeKeyList;
            this.replaceList = replaceList;
            this.appendList = appendList;
        }

        @Override
        public List<IncludeKey> getRemovedIncludeKeyList() {
            return this.removedIncludeKeyList;
        }

        @Override
        public List<TiesImport.TieImport> getReplaceTieImportList() {
            return this.replaceList;
        }

        @Override
        public List<TiesImport.TieImport> getAppendTieImportList() {
            return this.appendList;
        }
    }

    private static class TieImportList
    extends AbstractList<TiesImport.TieImport>
    implements RandomAccess {
        private final TiesImport.TieImport[] array;

        private TieImportList(TiesImport.TieImport[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TiesImport.TieImport get(int index) {
            return this.array[index];
        }
    }
}

