/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.AttributeFormatter;
import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.tools.format.catalogs.AttributeFormatterCatalog;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class AttributeFormatterParser {
    private AttributeFormatterParser() {
    }

    public static AttributeFormatter parse(String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.attribute();
        }
        try {
            return AttributeFormatterParser.parse(pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static AttributeFormatter parse(String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext), pattern);
        return new InternalAttributeFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;

        private InternalInstructionResolver(FormatContext formatContext) {
            this.provider = formatContext.getInstructionResolverProvider();
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(ValueFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return AttributeFormatterCatalog.FORMSYNTAX;
                }
                case "value": {
                    return AttributeFormatterCatalog.VALUE;
                }
            }
            return null;
        }
    }

    private static class InternalAttributeFormatter
    implements AttributeFormatter {
        private final Object[] partArray;

        private InternalAttributeFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatAttributeValue(String attributeValue, int valueIndex, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                AttributeFormatter formatter = (AttributeFormatter)obj;
                buf.append(formatter.formatAttributeValue(attributeValue, valueIndex, formatSource));
            }
            return buf.toString();
        }
    }
}

