/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;

public final class FicheBlockFormat {
    private static final String LI_PREFIX = "\u2022 ";

    private FicheBlockFormat() {
    }

    public static void textFormat(Appendable appendable, FicheBlocks ficheBlocks, String separator) throws IOException {
        boolean suivant = false;
        for (FicheBlock ficheBlock : ficheBlocks) {
            if (suivant) {
                appendable.append(separator);
            } else {
                suivant = true;
            }
            FicheBlockFormat.textFormat(appendable, ficheBlock, separator);
        }
    }

    private static void textFormat(Appendable buf, FicheBlock ficheBlock, String separator) throws IOException {
        if (ficheBlock instanceof P) {
            FicheBlockFormat.addParagraphBlock(buf, (P)ficheBlock, null);
        } else if (ficheBlock instanceof H) {
            FicheBlockFormat.addParagraphBlock(buf, (H)ficheBlock, separator);
            buf.append(separator);
        } else if (ficheBlock instanceof Code) {
            Code code = (Code)ficheBlock;
            int size2 = code.size();
            buf.append(separator);
            buf.append("+++++");
            buf.append(separator);
            for (int j = 0; j < size2; ++j) {
                if (j > 0) {
                    buf.append(separator);
                }
                FicheBlockFormat.addLn(buf, code.get(j));
            }
            buf.append(separator);
            buf.append("+++++");
            buf.append(separator);
        } else if (ficheBlock instanceof Table) {
            Table table = (Table)ficheBlock;
            buf.append(separator);
            buf.append("=====");
            buf.append(separator);
            int size2 = table.size();
            for (int j = 0; j < size2; ++j) {
                if (j > 0) {
                    buf.append(separator);
                }
                Tr tr = table.get(j);
                FicheBlockFormat.addTr(buf, tr);
            }
            buf.append(separator);
            buf.append("=====");
            buf.append(separator);
        } else if (ficheBlock instanceof Ul) {
            FicheBlockFormat.addUl(buf, (Ul)ficheBlock, 0, separator);
        } else if (ficheBlock instanceof Div) {
            buf.append(separator);
            buf.append("!!!!!");
            buf.append(separator);
            Div divFicheBlocks = (Div)ficheBlock;
            int size2 = divFicheBlocks.size();
            for (int j = 0; j < size2; ++j) {
                if (j > 0) {
                    buf.append(separator);
                }
                FicheBlock ficheBlock2 = (FicheBlock)divFicheBlocks.get(j);
                FicheBlockFormat.textFormat(buf, ficheBlock2, separator);
            }
            buf.append(separator);
            buf.append("!!!!!");
            buf.append(separator);
        }
    }

    public static List<String> valuesFormat(FicheBlocks ficheBlocks) {
        ArrayList<String> values = new ArrayList<String>();
        ValuesBuilder vb = new ValuesBuilder(values);
        vb.addAll(ficheBlocks);
        return values;
    }

    private static void addLn(Appendable buf, Ln ln) throws IOException {
        int indentation = ln.getIndentation();
        for (int i = 0; i < indentation; ++i) {
            buf.append('\u00a0');
        }
        buf.append(ln.getValue());
    }

    private static void addUl(Appendable buf, Ul ul, int depth, String separator) throws IOException {
        int liSize = ul.size();
        for (int j = 0; j < liSize; ++j) {
            if (j > 0) {
                buf.append(separator);
            }
            Li li = ul.get(j);
            FicheBlockFormat.addLi(buf, li, depth, separator);
        }
    }

    private static void addTr(Appendable buf, Tr tr) throws IOException {
        buf.append('|');
        for (Td td : tr) {
            for (Object obj : td) {
                buf.append(obj.toString());
            }
            buf.append('|');
        }
    }

    private static void addLi(Appendable buf, Li li, int depth, String separator) throws IOException {
        int liSize = li.size();
        boolean premier = true;
        StringBuilder preBuf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            preBuf.append('\u00a0');
        }
        String pre = preBuf.toString();
        for (int j = 0; j < liSize; ++j) {
            FicheBlock prg;
            if (j > 0) {
                buf.append(separator);
            }
            if ((prg = li.get(j)) instanceof P) {
                if (premier) {
                    premier = false;
                    FicheBlockFormat.addParagraphBlock(buf, (P)prg, pre + "\u2013 ");
                    continue;
                }
                FicheBlockFormat.addParagraphBlock(buf, (P)prg, pre + "\u00a0 ");
                continue;
            }
            if (!(prg instanceof Ul)) continue;
            FicheBlockFormat.addUl(buf, (Ul)prg, depth + 1, separator);
        }
    }

    private static void addParagraphBlock(Appendable buf, ParagraphBlock paragraphBlock, String pre) throws IOException {
        if (pre != null) {
            buf.append(pre);
        }
        for (Object obj : paragraphBlock) {
            buf.append(obj.toString());
        }
    }

    private static class ValuesBuilder {
        private final List<String> values;

        private ValuesBuilder(List<String> values) {
            this.values = values;
        }

        private void addAll(FicheBlocks ficheBlocks) {
            for (FicheBlock ficheBlock : ficheBlocks) {
                if (ficheBlock instanceof P) {
                    this.addTextContent((P)ficheBlock, "");
                } else if (ficheBlock instanceof H) {
                    this.addTextContent((H)ficheBlock, "");
                } else if (ficheBlock instanceof Code) {
                    for (Ln ln : (Code)ficheBlock) {
                        this.addTextContent(ln, "");
                    }
                } else if (ficheBlock instanceof Table) {
                    for (Tr tr : (Table)ficheBlock) {
                        this.addTr(tr);
                    }
                } else if (ficheBlock instanceof Ul) {
                    this.addUl((Ul)ficheBlock, 0);
                } else if (ficheBlock instanceof Div) {
                    this.addAll((Div)ficheBlock);
                }
                if (!(ficheBlock instanceof ZoneBlock)) continue;
                this.addTextContent(((ZoneBlock)ficheBlock).getLegende(), "");
            }
        }

        private void addTextContent(TextContent textContent, String prefix) {
            if (textContent.isEmpty()) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            int length = prefix.length();
            if (length > 0) {
                buf.append(prefix);
            }
            for (Object obj : textContent) {
                buf.append(obj.toString());
            }
            if (buf.length() > length) {
                this.values.add(buf.toString());
            }
        }

        private void addTr(Tr tr) {
            StringBuilder buf = new StringBuilder();
            boolean done = false;
            buf.append('|');
            for (Td td : tr) {
                for (Object obj : td) {
                    String s = obj.toString();
                    if (s.length() <= 0) continue;
                    buf.append(s);
                    done = true;
                }
                buf.append('|');
            }
            if (done) {
                this.values.add(buf.toString());
            }
        }

        private void addUl(Ul ul, int depth) {
            for (Li li : ul) {
                this.addLi(li, depth);
            }
        }

        private void addLi(Li li, int depth) {
            for (FicheBlock ficheBlock : li) {
                if (ficheBlock instanceof P) {
                    this.addTextContent((P)ficheBlock, FicheBlockFormat.LI_PREFIX);
                    continue;
                }
                if (!(ficheBlock instanceof Ul)) continue;
                this.addUl((Ul)ficheBlock, depth + 1);
            }
        }
    }
}

