/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.opendocument.io.odtable.TableSettings;

public class TableExportOds {
    private final List<OdTableDef> tableDefList;
    private final OdSource contentOdSource;
    private final OdsOptions odsOptions;

    TableExportOds(List<OdTableDef> tableDefList, OdSource contentOdSource, OdsOptions odsOptions) {
        this.tableDefList = tableDefList;
        this.contentOdSource = contentOdSource;
        this.odsOptions = odsOptions;
    }

    public List<OdTableDef> getTableDefList() {
        return this.tableDefList;
    }

    public OdSource getContentOdSource() {
        return this.contentOdSource;
    }

    public void write(OutputStream outputStream, boolean fixFirstRow) throws IOException {
        OdSource settingsOdsSource;
        if (fixFirstRow) {
            ArrayList<TableSettings> settingsList = new ArrayList<TableSettings>();
            for (OdTableDef tableDef : this.tableDefList) {
                settingsList.add(TableSettings.init(tableDef.getTableName()).fixedRows(1));
            }
            settingsOdsSource = OdUtils.getSettingsOdSource(settingsList);
        } else {
            settingsOdsSource = null;
        }
        OdZipEngine.run(outputStream, OdZip.spreadSheet().stylesOdSource(OdUtils.toStyleOdSource(this.odsOptions.elementMaps(), true)).contentOdSource(this.contentOdSource).settingsOdSource(settingsOdsSource));
    }
}

