/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.scrutari.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.fichotheque.tools.exportation.scrutari.CorpusScrutariDefBuilder;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportDefBuilder;
import net.fichotheque.tools.exportation.scrutari.ThesaurusScrutariDefBuilder;
import net.fichotheque.tools.exportation.scrutari.WrongFormatSourceKeyException;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ScrutariExportDefDOMReader {
    private final Fichotheque fichotheque;
    private final ScrutariExportDefBuilder scrutariExportDefBuilder;
    private final MessageHandler messageHandler;

    public ScrutariExportDefDOMReader(Fichotheque fichotheque, ScrutariExportDefBuilder scrutariExportDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.scrutariExportDefBuilder = scrutariExportDefBuilder;
        this.messageHandler = messageHandler;
    }

    public ScrutariExportDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static ScrutariExportDefDOMReader init(Fichotheque fichotheque, ScrutariExportDefBuilder scrutariExportDefBuilder, MessageHandler messageHandler) {
        return new ScrutariExportDefDOMReader(fichotheque, scrutariExportDefBuilder, messageHandler);
    }

    private static void checkValueList(List<String> valueList) {
        int size = valueList.size();
        boolean remove = true;
        for (int i = size - 1; i >= 0; --i) {
            String value = valueList.get(i);
            if (value.length() == 0) {
                if (remove) {
                    valueList.remove(i);
                    continue;
                }
                valueList.set(i, "-");
                continue;
            }
            remove = false;
        }
    }

    private static void addValueList(StringBuilder buf, List<String> valueList) {
        for (String value : valueList) {
            buf.append(value);
            buf.append("\n");
        }
        buf.append("\n");
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "authority": {
                    String authority = DOMUtils.readSimpleElement(element);
                    if (authority.length() <= 0) break;
                    try {
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setAuthority(authority);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, authority);
                    }
                    break;
                }
                case "base-name": {
                    String baseName = DOMUtils.readSimpleElement(element);
                    if (baseName.length() <= 0) break;
                    try {
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setBaseName(baseName);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, baseName);
                    }
                    break;
                }
                case "base-icon": {
                    ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setBaseIcon(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "langs-ui": {
                    DOMUtils.readChildren(element, new LangsUiConsumer());
                    break;
                }
                case "fiche-pattern": {
                    String fichePatternString = DOMUtils.readSimpleElement(element);
                    if (fichePatternString.length() <= 0) break;
                    try {
                        AccoladePattern pattern = new AccoladePattern(fichePatternString);
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setFicheHrefPattern(pattern);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, fichePatternString);
                    }
                    break;
                }
                case "motcle-pattern": {
                    String motclePatternString = DOMUtils.readSimpleElement(element);
                    if (motclePatternString.length() <= 0) break;
                    try {
                        AccoladePattern pattern = new AccoladePattern(motclePatternString);
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setMotcleHrefPattern(pattern);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, motclePatternString);
                    }
                    break;
                }
                case "corpus-def": {
                    String corpusString = element.getAttribute("corpus");
                    if (corpusString.length() == 0) {
                        DomMessages.emptyAttribute(ScrutariExportDefDOMReader.this.messageHandler, tagName, "corpus");
                        break;
                    }
                    try {
                        SubsetKey corpusKey = SubsetKey.parse((short)1, corpusString);
                        CorpusDefConsumer corpusDefConsumer = new CorpusDefConsumer(corpusKey);
                        DOMUtils.readChildren(element, corpusDefConsumer);
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.addCorpusScrutariDef(corpusDefConsumer.toCorpusScrutariDef());
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongAttributeValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, "corpus", corpusString);
                    }
                    break;
                }
                case "thesaurus-def": {
                    String thesaurusString = element.getAttribute("thesaurus");
                    if (thesaurusString.length() == 0) {
                        DomMessages.emptyAttribute(ScrutariExportDefDOMReader.this.messageHandler, tagName, "thesaurus");
                        break;
                    }
                    try {
                        SubsetKey thesaurusKey = SubsetKey.parse((short)2, thesaurusString);
                        ThesaurusDefConsumer thesaurusDefConsumer = new ThesaurusDefConsumer(thesaurusKey);
                        DOMUtils.readChildren(element, thesaurusDefConsumer);
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.addThesaurusScrutariDef(thesaurusDefConsumer.toThesaurusScrutariDef());
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongAttributeValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, "thesaurus", thesaurusString);
                    }
                    break;
                }
                case "intitule-short": {
                    DOMUtils.readChildren(element, new BaseIntituleConsumer(1));
                    break;
                }
                case "intitule-long": {
                    DOMUtils.readChildren(element, new BaseIntituleConsumer(2));
                    break;
                }
                case "target-name": {
                    ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setTargetName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "target-path": {
                    String targetPath = DOMUtils.readSimpleElement(element);
                    try {
                        RelativePath relativePath = RelativePath.parse(targetPath);
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.setTargetPath(relativePath);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, targetPath);
                    }
                    break;
                }
                case "label": 
                case "lib": {
                    try {
                        LabelUtils.readLabel(element, ScrutariExportDefDOMReader.this.scrutariExportDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(ScrutariExportDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                case "include-token": {
                    String includeToken = DOMUtils.readSimpleElement(element);
                    if (includeToken.length() <= 0) break;
                    ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.addIncludeToken(includeToken);
                    break;
                }
                default: {
                    if (SelectionDOMUtils.readSelectionOptions(ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.getSelectionOptionsBuilder(), ScrutariExportDefDOMReader.this.fichotheque, element)) break;
                    DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }

    private class ComplementConsumer
    implements Consumer<Element> {
        private final List<String> valueList = new ArrayList<String>();
        private final LabelChangeBuilder changeLabelHolderBuilder = new LabelChangeBuilder();

        private ComplementConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("value")) {
                this.valueList.add(DOMUtils.readSimpleElement(element));
            } else if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        this.changeLabelHolderBuilder.putLabel(label);
                    }
                }
                catch (ParseException ile) {
                    DomMessages.wrongLangAttribute(ScrutariExportDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                }
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }

        private void startNewComplement() {
            this.valueList.clear();
            this.changeLabelHolderBuilder.clear();
        }

        private void append(StringBuilder buf) {
            ScrutariExportDefDOMReader.checkValueList(this.valueList);
            if (this.valueList.isEmpty()) {
                return;
            }
            buf.append("complement");
            if (this.changeLabelHolderBuilder.getAddedLabelCount() > 0) {
                Labels labels = this.changeLabelHolderBuilder.toLabels();
                buf.append(" > ");
                boolean next = false;
                for (Label label : labels) {
                    if (next) {
                        buf.append(',');
                    } else {
                        next = true;
                    }
                    buf.append(label.getLang().toString());
                    buf.append("=\"");
                    StringUtils.escapeDoubleQuote(label.getLabelString(), buf);
                    buf.append("\"");
                }
            }
            buf.append('\n');
            ScrutariExportDefDOMReader.addValueList(buf, this.valueList);
            this.valueList.clear();
            this.changeLabelHolderBuilder.clear();
        }
    }

    private class FormatDefConsumer
    implements Consumer<Element> {
        private final List<String> valueList = new ArrayList<String>();

        private FormatDefConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("value")) {
                this.valueList.add(DOMUtils.readSimpleElement(element));
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }

        private void append(StringBuilder buf, String fieldName) {
            ScrutariExportDefDOMReader.checkValueList(this.valueList);
            if (this.valueList.isEmpty()) {
                return;
            }
            buf.append(fieldName);
            buf.append("\n");
            ScrutariExportDefDOMReader.addValueList(buf, this.valueList);
            this.valueList.clear();
        }
    }

    private class ThesaurusDefConsumer
    implements Consumer<Element> {
        private final ThesaurusScrutariDefBuilder builder;
        private final StringBuilder fieldGenerationSourceBuf;

        private ThesaurusDefConsumer(SubsetKey thesaurusKey) {
            this.builder = new ThesaurusScrutariDefBuilder(thesaurusKey);
            this.fieldGenerationSourceBuf = new StringBuilder();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("motcle-format")) {
                String motcleFormatPattern = DOMUtils.readSimpleElement(element);
                if (motcleFormatPattern.length() > 0) {
                    if (this.fieldGenerationSourceBuf.length() > 0) {
                        this.fieldGenerationSourceBuf.append("\n\n");
                    }
                    this.fieldGenerationSourceBuf.append("labels\nthis\n");
                    this.fieldGenerationSourceBuf.append(motcleFormatPattern);
                }
            } else if (tagName.equals("field-generation")) {
                if (this.fieldGenerationSourceBuf.length() > 0) {
                    this.fieldGenerationSourceBuf.append("\n\n");
                }
                this.fieldGenerationSourceBuf.append(XMLUtils.getRawData(element));
            } else if (tagName.equals("whole-thesaurus")) {
                this.builder.setWholeThesaurus(true);
            } else if (tagName.equals("include-token")) {
                String includeToken = DOMUtils.readSimpleElement(element);
                if (includeToken.length() > 0) {
                    this.builder.addIncludeToken(includeToken);
                }
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }

        public ThesaurusScrutariDef toThesaurusScrutariDef() {
            return this.builder.setFieldGenerationSource(this.fieldGenerationSourceBuf.toString()).toThesaurusScrutariDef();
        }
    }

    private class CorpusDefConsumer
    implements Consumer<Element> {
        private final CorpusScrutariDefBuilder builder;
        private final FormatDefConsumer formatDefConsumer;
        private final ComplementConsumer complementConsumer;
        private final StringBuilder fieldGenerationSourceBuf;

        private CorpusDefConsumer(SubsetKey corpusKey) {
            this.builder = new CorpusScrutariDefBuilder(corpusKey);
            this.formatDefConsumer = new FormatDefConsumer();
            this.complementConsumer = new ComplementConsumer();
            this.fieldGenerationSourceBuf = new StringBuilder();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("date")) {
                String dateString = DOMUtils.readSimpleElement(element);
                try {
                    this.builder.setDateKey(dateString);
                }
                catch (ParseException | WrongFormatSourceKeyException e) {
                    DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, dateString);
                }
            } else if (tagName.equals("titre-format")) {
                DOMUtils.readChildren(element, this.formatDefConsumer);
                this.formatDefConsumer.append(this.fieldGenerationSourceBuf, "titre");
            } else if (tagName.equals("soustitre-format")) {
                DOMUtils.readChildren(element, this.formatDefConsumer);
                this.formatDefConsumer.append(this.fieldGenerationSourceBuf, "soustitre");
            } else if (tagName.equals("complement")) {
                this.complementConsumer.startNewComplement();
                DOMUtils.readChildren(element, this.complementConsumer);
                this.complementConsumer.append(this.fieldGenerationSourceBuf);
            } else if (tagName.equals("attribute")) {
                CheckedLocalKey localKey;
                CheckedNameSpace nameSpace;
                String nameSpaceString = element.getAttribute("ns");
                if (nameSpaceString.isEmpty()) {
                    DomMessages.emptyAttribute(ScrutariExportDefDOMReader.this.messageHandler, "attribute", "ns");
                    return;
                }
                try {
                    nameSpace = CheckedNameSpace.parse(nameSpaceString);
                }
                catch (ParseException pe) {
                    DomMessages.wrongAttributeValue(ScrutariExportDefDOMReader.this.messageHandler, "attribute", "ns", nameSpaceString);
                    return;
                }
                String localKeyString = element.getAttribute("key");
                if (localKeyString.isEmpty()) {
                    DomMessages.emptyAttribute(ScrutariExportDefDOMReader.this.messageHandler, "attribute", "key");
                    return;
                }
                try {
                    localKey = CheckedLocalKey.parse(localKeyString);
                }
                catch (ParseException pe) {
                    DomMessages.wrongAttributeValue(ScrutariExportDefDOMReader.this.messageHandler, "attribute", "key", localKeyString);
                    return;
                }
                AttributeKey attributeKey = AttributeKey.build(nameSpace, localKey);
                DOMUtils.readChildren(element, this.formatDefConsumer);
                this.formatDefConsumer.append(this.fieldGenerationSourceBuf, attributeKey.toString());
            } else if (tagName.equals("href-pattern")) {
                String hrefPatternString = DOMUtils.readSimpleElement(element);
                if (hrefPatternString.length() > 0) {
                    try {
                        AccoladePattern pattern = new AccoladePattern(hrefPatternString);
                        this.builder.setHrefPattern(pattern);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, hrefPatternString);
                    }
                }
            } else if (tagName.equals("multilang-key")) {
                String oldKey = DOMUtils.readSimpleElement(element);
                if (oldKey.equals("_default")) {
                    this.builder.setLanguiMode();
                } else {
                    try {
                        FieldKey fieldKey = FieldKey.parse(oldKey);
                        this.builder.setFieldMode(fieldKey);
                    }
                    catch (ParseException pe) {
                        try {
                            SubsetKey subsetKey = SubsetKey.parse(oldKey);
                            if (subsetKey.isThesaurusSubset()) {
                                this.builder.setThesaurusMode(subsetKey);
                            }
                        }
                        catch (ParseException pe2) {
                            Langs langs = LangsUtils.toCleanLangs(oldKey);
                            this.builder.setCustomMode(langs);
                        }
                    }
                }
            } else if (tagName.equals("multilang")) {
                String mode = element.getAttribute("mode");
                String param = element.getAttribute("param");
                switch (mode) {
                    case "langui": {
                        this.builder.setLanguiMode();
                        break;
                    }
                    case "field": {
                        try {
                            FieldKey fieldKey = FieldKey.parse(param);
                            this.builder.setFieldMode(fieldKey);
                        }
                        catch (ParseException fieldKey) {}
                        break;
                    }
                    case "thesaurus": {
                        try {
                            SubsetKey subsetKey = SubsetKey.parse((short)2, param);
                            this.builder.setThesaurusMode(subsetKey);
                        }
                        catch (ParseException subsetKey) {}
                        break;
                    }
                    case "custom": {
                        Langs langs = LangsUtils.toCleanLangs(param);
                        this.builder.setCustomMode(langs);
                    }
                }
            } else if (tagName.equals("field-generation")) {
                this.fieldGenerationSourceBuf.append(XMLUtils.getRawData(element));
            } else if (tagName.equals("include-token")) {
                String includeToken = DOMUtils.readSimpleElement(element);
                if (includeToken.length() > 0) {
                    this.builder.addIncludeToken(includeToken);
                }
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }

        public CorpusScrutariDef toCorpusScrutariDef() {
            this.builder.setFieldGenerationSource(this.fieldGenerationSourceBuf.toString());
            return this.builder.toCorpusScrutariDef();
        }
    }

    private class BaseIntituleConsumer
    implements Consumer<Element> {
        private final int baseIntituleType;

        private BaseIntituleConsumer(int baseIntituleType) {
            this.baseIntituleType = baseIntituleType;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.putBaseLabel(this.baseIntituleType, label);
                    }
                }
                catch (ParseException ile) {
                    DomMessages.wrongLangAttribute(ScrutariExportDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                }
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }
    }

    private class LangsUiConsumer
    implements Consumer<Element> {
        private LangsUiConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lang")) {
                String langString = DOMUtils.readSimpleElement(element);
                try {
                    Lang lang = Lang.parse(langString);
                    ScrutariExportDefDOMReader.this.scrutariExportDefBuilder.addLang(lang);
                }
                catch (ParseException lie) {
                    DomMessages.wrongElementValue(ScrutariExportDefDOMReader.this.messageHandler, tagName, langString);
                }
            } else {
                DomMessages.unknownTagWarning(ScrutariExportDefDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

