/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FicheBlockDOMReader {
    private final HtmlCleaner htmlCleaner;
    private final MessageHandler messageHandler;

    public FicheBlockDOMReader(HtmlCleaner htmlCleaner, MessageHandler messageHandler) {
        this.htmlCleaner = htmlCleaner;
        this.messageHandler = messageHandler;
    }

    public List<FicheBlock> readFicheBlockList(Element element) {
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element child;
            FicheBlock ficheBlock;
            if (liste.item(j).getNodeType() != 1 || (ficheBlock = this.readFicheBlock(child = (Element)liste.item(j))) == null) continue;
            list.add(ficheBlock);
        }
        return list;
    }

    public FicheBlock readFicheBlock(Element element) {
        switch (element.getTagName()) {
            case "p": {
                return this.readP(element);
            }
            case "ul": {
                return this.readUl(element);
            }
            case "h": {
                return this.readH(element);
            }
            case "code": {
                return this.readCode(element);
            }
            case "table": {
                return this.readTable(element);
            }
            case "insert": {
                return this.readInsert(element);
            }
            case "div": {
                return this.readDiv(element);
            }
            case "cdatadiv": {
                return this.readCdatadiv(element);
            }
        }
        return null;
    }

    public P readP(Element element) {
        short type = P.typeToShort(element.getAttribute("type"));
        P p = new P(type);
        p.setSource(element.getAttribute("source"));
        this.readAtts(element, p);
        this.readContentList(p, element);
        return p;
    }

    public H readH(Element element) {
        int level = 1;
        try {
            level = Integer.parseInt(element.getAttribute("level"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        H h = new H(level);
        this.readAtts(element, h);
        this.readContentList(h, element);
        return h;
    }

    public Ul readUl(Element element) {
        Ul ul = null;
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Li li;
            Element child;
            String tagname;
            if (nodeList.item(j).getNodeType() != 1 || !(tagname = (child = (Element)nodeList.item(j)).getTagName()).equals("li") || (li = this.readLi(child)) == null) continue;
            if (ul == null) {
                ul = new Ul(li);
                continue;
            }
            ul.add(li);
        }
        if (ul != null) {
            this.readAtts(element, ul);
        }
        return ul;
    }

    public Li readLi(Element element) {
        Li li;
        List<FicheBlock> list = this.readFicheBlockList(element);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        FicheBlock firstFicheBlock = list.get(0);
        if (firstFicheBlock instanceof P) {
            li = new Li((P)firstFicheBlock);
        } else {
            li = new Li(new P());
            if (li.isValidFicheBlock(firstFicheBlock)) {
                li.add(firstFicheBlock);
            }
        }
        this.readAtts(element, li);
        for (int i = 1; i < size; ++i) {
            FicheBlock ficheBlock = list.get(i);
            if (!li.isValidFicheBlock(ficheBlock)) continue;
            li.add(ficheBlock);
        }
        return li;
    }

    public Code readCode(Element element) {
        short type = Code.typeToShort(element.getAttribute("type"));
        Code code = new Code(type);
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Element child;
            String tagname;
            if (nodeList.item(j).getNodeType() != 1 || !(tagname = (child = (Element)nodeList.item(j)).getTagName()).equals("ln")) continue;
            code.add(this.readLn(child));
        }
        this.readZoneBlock(code, element);
        return code;
    }

    public Table readTable(Element element) {
        Table table = new Table();
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            if (nodeList.item(j).getNodeType() != 1) continue;
            Element child = (Element)nodeList.item(j);
            String tagname = child.getTagName();
            if (tagname.equals("tr")) {
                table.add(this.readTr(child));
                continue;
            }
            if (!tagname.equals("caption")) continue;
            String caption = XMLUtils.getData(child);
            table.getLegendeBuilder().addText(caption);
        }
        this.readZoneBlock(table, element);
        return table;
    }

    public Tr readTr(Element element) {
        Tr tr = new Tr();
        this.readAtts(element, tr);
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Element child;
            String tagname;
            if (nodeList.item(j).getNodeType() != 1 || !(tagname = (child = (Element)nodeList.item(j)).getTagName()).equals("td")) continue;
            tr.add(this.readTd(child));
        }
        return tr;
    }

    public Ln readLn(Element element) {
        int indentation = 0;
        try {
            indentation = Integer.parseInt(element.getAttribute("indent"));
            if (indentation < 0) {
                indentation = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Ln ln = new Ln(XMLUtils.getData(element, false), indentation);
        this.readAtts(element, ln);
        return ln;
    }

    public Td readTd(Element element) {
        String typeString = element.getAttribute("type");
        Td td = new Td(Td.typeToShort(typeString));
        this.readAtts(element, td);
        this.readContentList(td, element);
        return td;
    }

    public Insert readInsert(Element element) {
        Insert insert;
        block22: {
            try {
                short type = Insert.typeToShort(element.getAttribute("type"));
                insert = new Insert(type);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            insert.setSrc(element.getAttribute("src"));
            insert.setRef(element.getAttribute("ref"));
            String creditString = element.getAttribute("credit");
            if (creditString.length() > 0) {
                insert.getCreditBuilder().addText(creditString);
            }
            insert.setPosition(Insert.positionToString(element.getAttribute("position")));
            try {
                int width = Integer.parseInt(element.getAttribute("width"));
                insert.setWidth(width);
            }
            catch (NumberFormatException width) {
                // empty catch block
            }
            try {
                int height = Integer.parseInt(element.getAttribute("height"));
                insert.setHeight(height);
            }
            catch (NumberFormatException height) {
                // empty catch block
            }
            String albumName = element.getAttribute("album");
            if (albumName.length() > 0) {
                try {
                    SubsetKey albumKey = SubsetKey.parse((short)5, albumName);
                    String idString = element.getAttribute("id");
                    if (idString.length() == 0) {
                        idString = element.getAttribute("idalbum");
                    }
                    if (idString.length() <= 0) break block22;
                    try {
                        int illustrationId = Integer.parseInt(idString);
                        String albumDimName = element.getAttribute("albumdim");
                        insert.setSubsetItem(albumKey, illustrationId, albumDimName);
                    }
                    catch (NumberFormatException illustrationId) {
                    }
                }
                catch (ParseException albumKey) {}
            } else {
                String addendaName = element.getAttribute("addenda");
                if (addendaName.length() > 0) {
                    try {
                        SubsetKey addendaKey = SubsetKey.parse((short)4, addendaName);
                        String idString = element.getAttribute("id");
                        if (idString.length() > 0) {
                            try {
                                int documentId = Integer.parseInt(idString);
                                insert.setSubsetItem(addendaKey, documentId, "");
                            }
                            catch (NumberFormatException documentId) {}
                        }
                    }
                    catch (ParseException addendaKey) {
                        // empty catch block
                    }
                }
            }
        }
        this.readZoneBlock(insert, element);
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            if (nodeList.item(j).getNodeType() != 1) continue;
            Element child = (Element)nodeList.item(j);
            String tagname = child.getTagName();
            if (tagname.equals("alt")) {
                this.readContentList(insert.getAltBuilder(), child);
                continue;
            }
            if (!tagname.equals("credit")) continue;
            this.readContentList(insert.getCreditBuilder(), child);
        }
        return insert;
    }

    public Div readDiv(Element element) {
        Div div = new Div();
        String langString = element.getAttribute("xml:lang");
        if (langString.length() > 0) {
            try {
                Lang lang = Lang.parse(langString);
                div.setLang(lang);
            }
            catch (ParseException lang) {
                // empty catch block
            }
        }
        this.readZoneBlock(div, element);
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Element child;
            String tagname;
            if (nodeList.item(j).getNodeType() != 1 || !(tagname = (child = (Element)nodeList.item(j)).getTagName()).equals("fbl")) continue;
            List<FicheBlock> list = this.readFicheBlockList(child);
            for (FicheBlock ficheBlock : list) {
                div.add(ficheBlock);
            }
        }
        return div;
    }

    public Cdatadiv readCdatadiv(Element element) {
        Cdatadiv cdatadiv = new Cdatadiv();
        this.readZoneBlock(cdatadiv, element);
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Element child;
            String tagname;
            if (nodeList.item(j).getNodeType() != 1 || !(tagname = (child = (Element)nodeList.item(j)).getTagName()).equals("cdata")) continue;
            String cdata = XMLUtils.getRawData(child);
            cdatadiv.setCdata(this.htmlCleaner.cleanHtml(cdata));
            break;
        }
        return cdatadiv;
    }

    private void readZoneBlock(ZoneBlock zoneBlock, Element element) {
        this.readAtts(element, zoneBlock);
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            if (liste.item(j).getNodeType() != 1) continue;
            Element child = (Element)liste.item(j);
            String tagname = child.getTagName();
            if (tagname.equals("numero")) {
                this.readContentList(zoneBlock.getNumeroBuilder(), child);
                continue;
            }
            if (!tagname.equals("legende")) continue;
            this.readContentList(zoneBlock.getLegendeBuilder(), child);
        }
    }

    public S readS(Element element) {
        short type;
        try {
            type = S.typeToShort(element.getAttribute("type"));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        S s = new S(type);
        s.setValue(XMLUtils.getData(element, false));
        String ref = element.getAttribute("ref");
        if (type == 7) {
            String src = element.getAttribute("src");
            if (src.length() > 0) {
                s.setRef(src);
                if (ref.length() > 0) {
                    s.putAtt("href", ref);
                }
            } else {
                s.setRef(ref);
            }
        } else {
            s.setRef(ref);
        }
        this.readSAtts(element, s);
        return s;
    }

    public void readContentList(TextContentBuilder pb, Element element) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element child;
            short type = list.item(i).getNodeType();
            if (type == 3) {
                String data = ((Text)list.item(i)).getData();
                if ((data = XMLUtils.cleanString(data, false)).length() <= 0) continue;
                pb.addText(data);
                continue;
            }
            if (type != 1 || !(child = (Element)list.item(i)).getTagName().equals("s")) continue;
            S span = this.readS(child);
            if (span != null) {
                pb.addS(span);
                continue;
            }
            String data = XMLUtils.getData(child, false);
            if (data.length() <= 0) continue;
            pb.addText(data);
        }
    }

    private void readAtts(Element element, AttConsumer attConsumer) {
        NamedNodeMap nodeMap = element.getAttributes();
        if (nodeMap != null) {
            int length = nodeMap.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)nodeMap.item(i);
                String name = attr.getName();
                if (name.startsWith("att-") && name.length() > 4) {
                    attConsumer.putAtt(name.substring(4), attr.getValue());
                    continue;
                }
                if (name.equals("class")) {
                    attConsumer.putAtt("class", attr.getValue());
                    continue;
                }
                if (name.equals("htmlid")) {
                    attConsumer.putAtt("id", attr.getValue());
                    continue;
                }
                if (name.equals("rowspan")) {
                    attConsumer.putAtt("rowspan", attr.getValue());
                    continue;
                }
                if (!name.equals("colspan")) continue;
                attConsumer.putAtt("colspan", attr.getValue());
            }
        }
    }

    private void readSAtts(Element element, AttConsumer attConsumer) {
        StringBuilder classBuf = new StringBuilder();
        NamedNodeMap nodeMap = element.getAttributes();
        if (nodeMap != null) {
            int length = nodeMap.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)nodeMap.item(i);
                String name = attr.getName();
                if (name.startsWith("att-") && name.length() > 4) {
                    attConsumer.putAtt(name.substring(4), attr.getValue());
                    continue;
                }
                if (name.equals("class")) {
                    if (classBuf.length() > 0) {
                        classBuf.append(' ');
                    }
                    classBuf.append(attr.getValue());
                    continue;
                }
                if (name.equals("subtype")) {
                    if (classBuf.length() > 0) {
                        classBuf.append(' ');
                    }
                    classBuf.append(attr.getValue());
                    continue;
                }
                if (name.equals("htmlid")) {
                    attConsumer.putAtt("id", attr.getValue());
                    continue;
                }
                if (name.equals("title")) {
                    attConsumer.putAtt("title", attr.getValue());
                    continue;
                }
                if (!name.equals("lang")) continue;
                attConsumer.putAtt("hreflang", attr.getValue());
            }
        }
        if (classBuf.length() > 0) {
            attConsumer.putAtt("class", classBuf.toString());
        }
    }
}

