/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class LogoResourceXMLPart
extends XMLPart {
    private static final Map<String, String> DEFAULT_MAP = new HashMap<String, String>();
    private final BdfServer bdfServer;

    public LogoResourceXMLPart(XMLWriter xmlWriter, BdfServer bdfServer) {
        super(xmlWriter);
        this.bdfServer = bdfServer;
    }

    public void appendForDestination(String destination) throws IOException {
        this.startOpenTag("resource");
        this.addAttribute("type", "image");
        switch (destination) {
            case "odt": {
                this.appendOdtLogo();
                break;
            }
            default: {
                this.endOpenTag();
            }
        }
        this.closeTag("resource");
    }

    private void appendOdtLogo() throws IOException {
        Map<String, String> logoMap = ConfigurationUtils.getOdtLogoParameters(this.bdfServer);
        if (!logoMap.containsKey("path")) {
            this.endOpenTag();
            return;
        }
        this.addAttribute("path", logoMap.get("path"));
        this.endOpenTag();
        for (Map.Entry<String, String> entry : logoMap.entrySet()) {
            String key = entry.getKey();
            if (key.equals("path")) continue;
            this.addParam(key, entry.getValue());
        }
        this.checkDefault(logoMap);
    }

    private void checkDefault(Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : DEFAULT_MAP.entrySet()) {
            String key = entry.getKey();
            if (map.containsKey(key)) continue;
            this.addParam(key, entry.getValue());
        }
    }

    private void addParam(String name, String value) throws IOException {
        this.startOpenTag("param");
        this.addAttribute("name", name);
        this.endOpenTag();
        this.addText(value);
        this.closeTag("param", false);
    }

    static {
        DEFAULT_MAP.put("width", "3cm");
        DEFAULT_MAP.put("height", "3cm");
        DEFAULT_MAP.put("anchor", "as-char");
        DEFAULT_MAP.put("style", "FicheLogo");
    }
}

