/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.sync;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.importation.engines.ThesaurusImportEngine;
import java.util.HashSet;
import java.util.Set;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.sync.MotcleSync;
import net.fichotheque.thesaurus.sync.ThesaurusSync;
import net.fichotheque.tools.thesaurus.sync.SyncScan;
import net.fichotheque.tools.thesaurus.sync.SyncScanResult;
import net.fichotheque.tools.thesaurus.sync.ThesaurusSyncResult;

public final class SyncEngine {
    private SyncEngine() {
    }

    public static ThesaurusSyncResult runThesaurusSync(EditSession editSession, BdfParameters bdfParameters, ThesaurusSync thesaurusSync, Thesaurus thesaurus) {
        ThesaurusImport creationImport;
        ThesaurusSyncResult thesaurusSyncResult = ThesaurusSyncResult.init();
        SyncScanResult syncResult = SyncScan.scanThesaurusImport(thesaurusSync, thesaurus);
        ThesaurusImport changeImport = syncResult.getChangeImport();
        if (changeImport != null) {
            ThesaurusImportEngine.runThesaurusImport(editSession, bdfParameters, changeImport);
            thesaurusSyncResult.setChangeCount(changeImport.getMotcleImportList().size());
        }
        if ((creationImport = syncResult.getCreationImport()) != null) {
            ThesaurusImportEngine.runThesaurusImport(editSession, bdfParameters, creationImport);
            thesaurusSyncResult.setCreationCount(creationImport.getMotcleImportList().size());
        }
        OrderEdit orderEdit = new OrderEdit(thesaurusSync, editSession.getFichothequeEditor().getThesaurusEditor(thesaurus));
        int orderCount = orderEdit.run();
        thesaurusSyncResult.setOrderCount(orderCount);
        return thesaurusSyncResult;
    }

    private static class OrderEdit {
        private final ThesaurusSync originSync;
        private final ThesaurusEditor destinationEditor;
        private final Thesaurus destination;
        private final Set<Integer> changeSet = new HashSet<Integer>();

        private OrderEdit(ThesaurusSync originSync, ThesaurusEditor destinationEditor) {
            this.originSync = originSync;
            this.destinationEditor = destinationEditor;
            this.destination = destinationEditor.getThesaurus();
        }

        private int run() {
            for (MotcleSync motcleSync : this.originSync.getFirstLevelList()) {
                Motcle destinationMotcle = this.destination.getMotcleByIdalpha(motcleSync.getIdalpha());
                try {
                    boolean done = this.destinationEditor.setParent(destinationMotcle, null);
                    if (done) {
                        this.changeSet.add(destinationMotcle.getId());
                    }
                    this.setParent(motcleSync, destinationMotcle);
                }
                catch (ParentRecursivityException done) {}
            }
            int p = 0;
            for (MotcleSync motcleSync : this.originSync.getFirstLevelList()) {
                Motcle destinationMotcle = this.destination.getMotcleByIdalpha(motcleSync.getIdalpha());
                boolean done = this.destinationEditor.setChildIndex(destinationMotcle, p);
                if (done) {
                    this.changeSet.add(destinationMotcle.getId());
                }
                this.setOrder(motcleSync);
                ++p;
            }
            return this.changeSet.size();
        }

        private void setParent(MotcleSync originParent, Motcle destinationParent) {
            for (MotcleSync orginChild : originParent.getChildList()) {
                Motcle destinationChild = this.destination.getMotcleByIdalpha(orginChild.getIdalpha());
                try {
                    boolean done = this.destinationEditor.setParent(destinationChild, destinationParent);
                    if (done) {
                        this.changeSet.add(destinationChild.getId());
                    }
                    this.setParent(orginChild, destinationChild);
                }
                catch (ParentRecursivityException parentRecursivityException) {}
            }
        }

        private void setOrder(MotcleSync originParent) {
            int p = 0;
            for (MotcleSync originChild : originParent.getChildList()) {
                Motcle destinationChild = this.destination.getMotcleByIdalpha(originChild.getIdalpha());
                boolean done = this.destinationEditor.setChildIndex(destinationChild, p);
                if (done) {
                    this.changeSet.add(destinationChild.getId());
                }
                this.setOrder(originChild);
                ++p;
            }
        }
    }
}

